/*
 * File:     TranscriberEvent.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Feb 4, 2005
 *
 */
package mpi.eudico.server.corpora.clomimpl.transcriber;


/**
 * Utility class to map Transcriber Events to Strings that can be embedded
 * in Annotations.
 *
 * @author hennie
 */
public class TranscriberEvent {
    public static String getEventString(String desc, String extent) {
        String enclosedPart = desc;
        String prefix = "";
        String suffix = "";

        if (extent != null) {
            if (extent.equals("begin")) {
                desc += "-";
            } else if (extent.equals("end")) {
                desc = "-" + desc;
            } else if (extent.equals("previous")) {
                prefix = "+";
            } else if (extent.equals("next")) {
                suffix = "+";
            }
        }

        return prefix + " [" + desc + "] " + suffix;
    }
}
