/*
 * File:     DirectoryTree.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.location;

import java.io.File;

import java.util.Vector;


/**
 * DOCUMENT ME!
 * $Id: DirectoryTree.java,v 1.1.1.1 2004/03/25 16:23:21 wouthuij Exp $
 * @author $Author: wouthuij $
 * @version $Revision: 1.1.1.1 $
 */
public interface DirectoryTree {
    /**
     * DOCUMENT ME!
     *
     * @param theTopNode DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getDirectories(File theTopNode);

    /**
     * DOCUMENT ME!
     *
     * @param subDirectory DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getFiles(File subDirectory);

    /**
     * DOCUMENT ME!
     *
     * @param theFile DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getOwner(File theFile);

    /**
     * DOCUMENT ME!
     *
     * @param theFile DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getAccessRights(File theFile);

    /**
     * DOCUMENT ME!
     *
     * @param subDirectory DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean containsDirectories(File subDirectory);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getPath();

    /**
     * DOCUMENT ME!
     *
     * @param theFile DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getTierNames(File theFile);

    /**
     * DOCUMENT ME!
     *
     * @param theFile DOCUMENT ME!
     * @param theTierName DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getCHATBlocks(File theFile, String theTierName);

    /**
     * DOCUMENT ME!
     *
     * @param theFile DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Vector getCHATBlocks(File theFile);

    /**
     * DOCUMENT ME!
     *
     * @param theFile DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getMediaFileName(File theFile);
}
