/*
 * File:     SQLStrings.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.corpora.util;


/**
 * DOCUMENT ME!
 * $Id: SQLStrings.java,v 1.1.1.1 2004/03/25 16:23:21 wouthuij Exp $
 * @author $Author: wouthuij $
 * @version $Revision: 1.1.1.1 $
 */
public class SQLStrings {
    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_JDBC_URL = "jdbc:oracle:thin:@sun01:1521:G8I";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_TRANSCRIPTIONS = "select sessions_name, owner, sessions_id, av_file, pal_ntsc from sessions";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_SESSION_INFO_1 = "SELECT codec, resolution, pal_ntsc, begin_time FROM sessions WHERE sessions_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_TIERS = "select tier_name, subject_id, tier_id from tier where sessions_id = ? and tier_id not in (select child from dependency where dependency_type = 'HAS' or dependency_type = 'has')";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_TRANSCRIBER = "select transcriber from tier where tier_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_QUALITY = "select quality from tier where tier_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_PARTICIPANT = "select subject_name from subject where subject_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_HAS_A_CHILDREN = "select child from dependency where parent = ? and dependency_type = 'HAS' or dependency_type = 'has'";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_CODETYPE = "select tier_type_name, owner, value_range_id from tier_type where tier_type_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_VALUE_RANGE = "select sample_value from value_range where value_range_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_TIER_TYPE_ID = "select tier_type_id from tier where tier_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_TIER_NAME = "select tier_name from tier where tier_id = ?";

    /** Holds value of property DOCUMENT ME! */
    public static final String SQL_GET_TAGS = "select begin_time, end_time, sample_value from sample where tier_id = ?";
}
