/*
 * File:     ServerConfiguration.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.server.util;


//import mpi.eudico.client.applet.EudicoApplet;
import mpi.eudico.server.corpora.clom.CorpusDatabase;

import mpi.eudico.server.corpora.clomimpl.abstr.CorpusDatabaseImpl;

//import mpi.eudico.server.media.rmi.MediaServer;
import java.rmi.Naming;


/**
 * Contains static values for server configuration purposes. The Eudico data
 * and  media servers can be located on different machines. The exact
 * configuration is defined in the html file on which the appletviewer is
 * started. This html file must have a ServerMode parameter in it. See the
 * code and external documentation for details regarding available
 * configurations.
 *
 * @author Albert Russel
 * @version 26-Jun-2000
 */
public class ServerConfiguration {
    // corpus data server

    /** Holds value of property DOCUMENT ME! */
    public static boolean USES_REMOTE_DATA_SERVER;

    /** Holds value of property DOCUMENT ME! */
    public static String CORPUS_DIRECTORY;

    /** Holds value of property DOCUMENT ME! */
    public static String DATASERVER_NAME = "mpisun00.mpi.nl"; // Temporary solution for external demo

    /** Holds value of property DOCUMENT ME! */
    public static String DATASERVER_IP = "172.16.16.91"; // Temporary solution for external demo

    /** Holds value of property DOCUMENT ME! */
    public static String DATASERVER_PUBLIC_IP = ""; // Temporary solution for external demo

    /** Holds value of property DOCUMENT ME! */
    public static String DATASERVER_PORT;

    /** Holds value of property DOCUMENT ME! */
    public static int DATASERVER_RMI_PORT = 3000;

    /** Holds value of property DOCUMENT ME! */
    public static CorpusDatabase CORPUS_DATABASE;

    // media data server

    /** Holds value of property DOCUMENT ME! */
    public static boolean USES_REMOTE_MEDIA_SERVER;

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIA_DIRECTORY;

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIASERVER_NAME = "mpisun00.mpi.nl"; // Temporary solution for external demo

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIASERVER_IP = "172.16.16.91"; // Temporary solution for external demo

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIASERVER_PUBLIC_IP = ""; // Temporary solution for external demo

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIASERVER_PORT;

    /** Holds value of property DOCUMENT ME! */
    public static int MEDIASERVER_RMI_PORT = 3001;

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIASERVER_PROTOCOL;

    /** Holds value of property DOCUMENT ME! */
    public static String MEDIASERVER_URLHEADER;

    /** Holds value of property DOCUMENT ME! */

    //public static MediaServer MEDIASERVER;

    /**
     * This method initializes the server parameters for specific server modes.
     * Depending on the serverMode parameter from the applet's html file
     * several  predefined or user definable configurations can be chosen. See
     * the code  and external documentation for details regarding available
     * configurations.
     *
     * @param applet the Applet that can ask for html parameters.
     */

    /*
    public static void set(EudicoApplet applet) {
        initParameters(applet);
        initCorpusDatabase();
        initMediaServer();
    }
    */
    /*
    private static void initParameters(EudicoApplet applet) {
        if (applet.isAnApplication()) {
            USES_REMOTE_DATA_SERVER = false;
            CORPUS_DIRECTORY = applet.getCorpusDirectory();

            USES_REMOTE_MEDIA_SERVER = false;
            MEDIA_DIRECTORY = applet.getMediaDirectory();
        } else {
            String serverMode = applet.getParameter("ServerMode");

            // external demo mode dataserver and media server on mpisun00 both on port 1099
            if (serverMode.equals("EXTERNAL_DEMO")) {
                USES_REMOTE_DATA_SERVER = true;
                DATASERVER_NAME = "mpisun00.mpi.nl";
                DATASERVER_IP = "172.16.16.91";
                DATASERVER_PUBLIC_IP = "";
                DATASERVER_PORT = "1099";
                DATASERVER_RMI_PORT = 3000;

                USES_REMOTE_MEDIA_SERVER = true;
                MEDIASERVER_NAME = "mpisun00.mpi.nl";
                MEDIASERVER_IP = "172.16.16.91";
                MEDIASERVER_PUBLIC_IP = "";
                MEDIASERVER_PORT = "1099";
                MEDIASERVER_RMI_PORT = 3001;
                MEDIASERVER_PROTOCOL = "RMI";
            }
            // dataserver on mpisunn22 and media server on mpisun00
            else if (serverMode.equals("MODE_001")) {
                USES_REMOTE_DATA_SERVER = true;
                DATASERVER_NAME = "mpisun22.mpi.nl";
                DATASERVER_IP = "172.16.17.122";
                DATASERVER_PUBLIC_IP = "";
                DATASERVER_PORT = "1099";
                DATASERVER_RMI_PORT = 3000;

                USES_REMOTE_MEDIA_SERVER = true;
                MEDIASERVER_NAME = "mpisun00.mpi.nl";
                MEDIASERVER_IP = "172.16.16.91";
                MEDIASERVER_PUBLIC_IP = "";
                MEDIASERVER_PORT = "1099";
                MEDIASERVER_RMI_PORT = 3001;
                MEDIASERVER_PROTOCOL = "RMI";
            }
            // dataserver and media server on mpisun00
            else if (serverMode.equals("MODE_002")) {
                USES_REMOTE_DATA_SERVER = true;
                DATASERVER_NAME = "mpisun00.mpi.nl";
                DATASERVER_IP = "172.16.17.122";
                DATASERVER_PUBLIC_IP = "";
                DATASERVER_PORT = "1098";
                DATASERVER_RMI_PORT = 3000;

                USES_REMOTE_MEDIA_SERVER = true;
                MEDIASERVER_NAME = "mpisun00.mpi.nl";
                MEDIASERVER_IP = "172.16.16.91";
                MEDIASERVER_PUBLIC_IP = "";
                MEDIASERVER_PORT = "1099";
                MEDIASERVER_RMI_PORT = 3001;
                MEDIASERVER_PROTOCOL = "RMI";
            }
            // dataserver and media server defined in the html file
            else if (serverMode.equals("HTML_DEFINED")) {
                USES_REMOTE_DATA_SERVER = true;
                DATASERVER_NAME = applet.getParameter("DATASERVER_NAME");
                DATASERVER_IP = applet.getParameter("DATASERVER_IP");
                DATASERVER_PUBLIC_IP = applet.getParameter(
                        "DATASERVER_PUBLIC_IP");
                DATASERVER_PORT = applet.getParameter("DATASERVER_PORT");
                DATASERVER_RMI_PORT = 3000;

                USES_REMOTE_MEDIA_SERVER = true;
                MEDIASERVER_NAME = applet.getParameter("MEDIASERVER_NAME");
                MEDIASERVER_IP = applet.getParameter("MEDIASERVER_IP");
                MEDIASERVER_PUBLIC_IP = applet.getParameter(
                        "MEDIASERVER_PUBLIC_IP");
                MEDIASERVER_PORT = applet.getParameter("MEDIASERVER_PORT");
                MEDIASERVER_RMI_PORT = 3001;
                MEDIASERVER_PROTOCOL = applet.getParameter(
                        "MEDIASERVER_PROTOCOL");
            }
            // dataserver local and media server on mpisun00
            else if (serverMode.equals("LOCAL_DATA_001")) {
                USES_REMOTE_DATA_SERVER = false;
                CORPUS_DIRECTORY = applet.getParameter("CORPUS_DIRECTORY");

                USES_REMOTE_MEDIA_SERVER = true;
                MEDIASERVER_NAME = "mpisun00.mpi.nl";
                MEDIASERVER_IP = "172.16.16.91";
                MEDIASERVER_PUBLIC_IP = "";
                MEDIASERVER_PORT = "1099";
                MEDIASERVER_RMI_PORT = 3001;
                MEDIASERVER_PROTOCOL = "RMI";
            }
            // dataserver and media server on localhost
            else if (serverMode.equals("LOCAL")) {
                USES_REMOTE_DATA_SERVER = false;
                CORPUS_DIRECTORY = applet.getParameter("CORPUS_DIRECTORY");

                USES_REMOTE_MEDIA_SERVER = false;
                MEDIA_DIRECTORY = applet.getParameter("MEDIA_DIRECTORY");
            } else {
                System.out.println("Unknown server mode : " + serverMode);
                System.exit(0);
            }
        }
    }
    */

    /**
     * Initialize the corpus database
     */
    private static void initCorpusDatabase() {
        try {
            if (USES_REMOTE_DATA_SERVER) {
                String url = "rmi://" + DATASERVER_NAME + ":" +
                    DATASERVER_PORT + "/CorpusDatabase";
                CORPUS_DATABASE = (CorpusDatabase) Naming.lookup(url);
                System.out.println("Using remote corpus data server....");
            } else {
                CORPUS_DATABASE = CorpusDatabaseImpl.Instance();
                System.out.println("Using local corpus data...." +
                    CORPUS_DIRECTORY);
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("DATASERVER_NAME : " + DATASERVER_NAME);
            System.exit(0);
        }
    }

    /**
     * Initialize the media server
     */
    private static void initMediaServer() {
        try {
            if (USES_REMOTE_MEDIA_SERVER) {
                if (MEDIASERVER_PROTOCOL.equals("RMI")) {
                    MEDIASERVER_URLHEADER = "rmi://" + MEDIASERVER_NAME + ":" +
                        MEDIASERVER_PORT + "/";

                    String url = MEDIASERVER_URLHEADER + "MediaServer";

                    //MEDIASERVER = (MediaServer) Naming.lookup(url);
                } else if (MEDIASERVER_PROTOCOL.equals("WEBNFS")) {
                    MEDIASERVER_URLHEADER = "nfs://" + MEDIASERVER_NAME + "/";
                }

                System.out.println("Using remote media data server....");
            } else {
                MEDIASERVER_URLHEADER = "file:" + MEDIA_DIRECTORY + "/";

                // replace the windows \ in the media directory by / for the URL Header
                MEDIASERVER_URLHEADER = MEDIASERVER_URLHEADER.replace('\\', '/');

                System.out.println("Using local media data...." +
                    MEDIA_DIRECTORY);
            }
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("MEDIASERVER_NAME : " + MEDIASERVER_NAME);
            System.exit(0);
        }
    }
}
