/*
 * File:     Tool.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.tool;

import java.util.Vector;


// import mpi.eudico.client.applet.EudicoApplet;

/**
 * The Tool interface defines the common methods shared by all EUDICO tools.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 26-Mar-1999
 */
public interface Tool {
    /**
     * Associate the Tool with a data set to work on.
     */
    public void setDataSet(Vector dataTreeNodes);

    /**
     * Tools can optionally be configured. After configuration they can be told
     * to run with this method. If there is no configuration possible, the
     * Tool can be executed right away.
     */
    public void execute();

    /**
     * Inquires if there are any results available after execution.
     *
     * @return DOCUMENT ME!
     */
    public boolean hasResults();

    /**
     * If there are results after execution, this method can be used to show
     * them.
     */
    public void showResults();

    /**
     * Inquires if a tool has a component that can be used to configure
     * parameters of the tool before execution.
     *
     * @return DOCUMENT ME!
     */
    public boolean hasConfigurator();

    /**
     * If it is available, a configuration tool may be created for setting tool
     * parameters.
     */
    public void createConfigurator();
}
