/*
 * File:     ToolAdministrator.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.tool;

import java.util.Vector;


/**
 * A ToolAdministrator is capable of giving the Tools that are available to
 * work with the ToolAdministrator itself and the Tools that are  available
 * for any other specific ToolAdministrator Object.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 29-Apr-1999
 */
public interface ToolAdministrator {
    /**
     * Returns the Tools that can work with this ToolAdministrator. If there
     * are no Tools available an empty Vector should be returned instead of
     * null.
     *
     * @return a Vector with ToolID's
     */
    public Vector getAvailableTools();

    /**
     * Some Tools are only applicable to a ToolAdministrator instance if
     * specific conditions are met. This method returns true if the specified
     * ToolCondition is met by the ToolAdministrator.
     *
     * @return DOCUMENT ME!
     */
    public boolean checkToolCondition(ToolCondition theCondition);
}
