/*
 * File:     ToolCondition.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.tool;

import java.io.Serializable;


/**
 * ToolConditions are used by ToolDatabase: ToolAdministrators are associated
 * with ToolIDs. Each ToolID in turn can be associated with one or more
 * ToolConditions that all have to be met for the ToolID to be applicable to
 * the ToolAdministrator. Example: Media Synchronized Viewers are applicable
 * to Transcriptions only if the Transcription meets the 'MEDIA_AVAILABLE'
 * condition.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 29-Apr-1999
 */
public class ToolCondition implements Serializable {
    /** Holds value of property DOCUMENT ME! */
    public static int MEDIA_AVAILABLE = 1;

    /** Holds value of property DOCUMENT ME! */
    public static int SPAN_AVAILABLE = 2;
    private int conditionNumber;

    /**
     * Creates a new ToolCondition instance
     *
     * @param theConditionNumber DOCUMENT ME!
     */
    public ToolCondition(int theConditionNumber) {
        conditionNumber = theConditionNumber;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int whichCondition() {
        return conditionNumber;
    }
}
