/*
 * File:     ToolProxy.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.tool;

import java.io.Serializable;

import java.util.Vector;

import javax.swing.JApplet;


/**
 * The ToolProxy class is a client based Tool that is used as a Proxy for a
 * server side Tool. It wraps all methods of RemoteTool with the methods of
 * Tool
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 29-Mar-1999
 */
public class ToolProxy implements Tool, Serializable {
    private RemoteTool remTool;
    private JApplet eudicoApplet;

    /**
     * Creates a new ToolProxy instance
     *
     * @param theRemoteTool DOCUMENT ME!
     */
    public ToolProxy(RemoteTool theRemoteTool) {
        remTool = theRemoteTool;
    }

    /**
     * Give Tool a back reference to the requesting applet. This only works for
     * client based tools.
     *
     * @param theApplet DOCUMENT ME!
     */
    public void setApplet(JApplet theApplet) {
        eudicoApplet = theApplet;
    }

    /**
     * Associate the Tool with a data set to work on.
     *
     * @param dataTreeNodes DOCUMENT ME!
     */
    public void setDataSet(Vector dataTreeNodes) {
        remTool.setDataSet(dataTreeNodes);
    }

    /**
     * Tools can optionally be configured. After configuration they can be told
     * to run with this method. If there is no configuration possible, the
     * Tool can be executed right away.
     */
    public void execute() {
        remTool.execute();
    }

    /**
     * Inquires if there are any results available after execution.
     *
     * @return DOCUMENT ME!
     */
    public boolean hasResults() {
        boolean results = false;

        results = remTool.hasResults();

        return results;
    }

    /**
     * If there are results after execution, this method can be used to show
     * them.
     */
    public void showResults() {
        remTool.showResults();
    }

    /**
     * Inquires if a tool has a component that can be used to configure
     * parameters of the tool before execution.
     *
     * @return DOCUMENT ME!
     */
    public boolean hasConfigurator() {
        boolean configurator = false;

        configurator = remTool.hasConfigurator();

        return configurator;
    }

    /**
     * If it is available, a configuration tool may be created for setting tool
     * parameters.
     */
    public void createConfigurator() {
        remTool.createConfigurator();
    }
}
