/*
 * File:     TranscriptionUtil.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.util;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

import java.util.Enumeration;
import java.util.Vector;


public class TranscriptionUtil {
    /**
     * MK:02/06/27<br>
     * A transcription contain tiers withour parent-tiers.
     * @param tthis this
     * @return Vector of TierImpl without parent-tier
     */
    public final static Vector getTopTiers(Transcription tthis) {
        Vector result = new Vector();

        for (Enumeration e = tthis.getTiers().elements(); e.hasMoreElements();) {
            Object o = e.nextElement();

            if (!(o instanceof TierImpl)) {
                continue;
            }

            TierImpl t = (TierImpl) o;

            // the parent tier
            TierImpl dad = (TierImpl) t.getParentTier();

            if (dad == null) {
                result.add(t);
            } else {
                //System.out.println(" -- tierpa " + dad.getName());
            }
        }

        return result;
    }
}
