/*
 * File:     FastStringRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Nov 18, 2003
 * $Id: FastStringRenderer.java,v 1.1 2004/03/30 12:07:31 wouthuij Exp $
 */
package mpi.library.swing;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;


/**
 * A smart renderer for table cells with String contents. Made
 * <code>NothingComponent</code> a package scope class in stead of an inner
 * class, in order to have other renderers use it as well.
 *
 * @author Copied from "Java Platform Performance: Strategies and Tactics" by
 *         Steve Wilson and Jeff Kesselman, published by Addison Wesley, 2000.
 */
public class FastStringRenderer extends DefaultTableCellRenderer {
    /**
     * Reference to a NothingComponent instance, that will be returned by
     * <code>getTableCellRendererComponent</code> in case of an empty,
     * unselected value.
     */
    protected Component stubRenderer = new NothingComponent();

    /* (non-Javadoc)
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(
     * javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        if (!isSelected && !hasFocus &&
                ((value == null) || (((String) value).length() == 0))) {
            return stubRenderer;
        }

        return super.getTableCellRendererComponent(table, value, isSelected,
            hasFocus, row, column);
    }
}
