/*
 * File:     MultiLineStringRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Nov 18, 2003
 * $Id: MultiLineStringRenderer.java,v 1.1 2004/03/30 12:07:31 wouthuij Exp $
 */
package mpi.library.swing;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;


/**
 * Based on the <code>FastStringRenderer</code>. One instance should be used
 * for all columns that wish to make use ofg this renderer!
 *
 * @author Wouter Huijnink, based on <a
 *         href="http://www2.gol.com/users/tame/swing/examples/src/table/MultiLineCellRenderer.java">
 *         this </a> online example.
 */
public class MultiLineStringRenderer extends JTextArea
    implements TableCellRenderer {
    /** The empty String */
    private static final String EMPTY_STRING = "";

    /** Border for selected cell */
    private static final Border BORDER_SELECTED = UIManager.getBorder(
            "Table.focusCellHighlightBorder");

    /** Border for unselected cell */
    private static final Border BORDER_EMPTY = new EmptyBorder(1, 2, 1, 2);

    /** Foreground color for focused cell */
    private static final Color FC_FOREGROUND = UIManager.getColor(
            "Table.focusCellForeground");

    /** Background color for focused cell */
    private static final Color FC_BACKGROUND = UIManager.getColor(
            "Table.focusCellBackground");

    /**
     * Reference to a NothingComponent instance, that will be returned by
     * <code>getTableCellRendererComponent</code> in case of an empty,
     * unselected value.
     */
    protected Component stubRenderer = new NothingComponent();

    /**
     * Creates a new MultiLineStringRenderer object.
     */
    public MultiLineStringRenderer() {
        setLineWrap(false);
        setWrapStyleWord(false);
        setEditable(false);
        setOpaque(true);
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(
     * javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        //if cell is empty, return the NothingComponent instance
        if (!isSelected && !hasFocus &&
                ((value == null) || (((String) value).length() == 0))) {
            return stubRenderer;
        }

        //otherwise, set the text-area attributes and return this instance
        if (isSelected) {
            setForeground(table.getSelectionForeground());
            setBackground(table.getSelectionBackground());
        } else {
            setForeground(table.getForeground());
            setBackground(table.getBackground());
        }

        setFont(table.getFont());

        if (hasFocus) {
            setBorder(BORDER_SELECTED);

            if (table.isCellEditable(row, column)) {
                setForeground(FC_FOREGROUND);
                setBackground(FC_BACKGROUND);
            }
        } else {
            setBorder(BORDER_EMPTY);
        }

        setText((value == null) ? EMPTY_STRING : value.toString());

        return this;
    }
}
