/*
 * File:     ResizingMultiLineStringRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Created on Nov 24, 2003
 * $Id: ResizingMultiLineStringRenderer.java,v 1.1 2004/03/30 12:07:31 wouthuij Exp $
 */
package mpi.library.swing;

import java.awt.Component;

import javax.swing.JTable;


/**
 * This Cell renderer adjust the height of the table row if necessary.
 *
 * @author Wouter Huijnink
 */
public class ResizingMultiLineStringRenderer extends MultiLineStringRenderer {
    /**
     * The height of a single line of the JTable instance passed to
     * getTableCellRendererComponent()
     */
    private int lineHeight;

    /**
     * The default number of lines of the JTable instance passed to
     * getTableCellRendererComponent()
     */
    private int defaultNrOfLines;

    /**
     * Creates a new instance
     *
     * @param lineHeight The height of a single line of the JTable instance
     *        passed to getTableCellRendererComponent()
     * @param defaultNrOfLines The default line number for the JTable. If the
     *        contents of a cell need more lines than the default, the row
     *        height will be adjusted.
     */
    public ResizingMultiLineStringRenderer(int lineHeight, int defaultNrOfLines) {
        super();
        this.lineHeight = lineHeight;
        this.defaultNrOfLines = defaultNrOfLines;
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(
     * javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        Component rendererComponent = super.getTableCellRendererComponent(table,
                value, isSelected, hasFocus, row, column);

        //if a text area instance is to be returned, adjust the row height if necessary
        if (rendererComponent == this) {
            int lineCount = this.getLineCount();

            if (lineCount > defaultNrOfLines) {
                int height = lineCount * lineHeight;

                if (height > table.getRowHeight(row)) {
                    table.setRowHeight(row, height);
                }
            }
        }

        return rendererComponent;
    }
}
