/*
 * File:     XmlUtil.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Id: XmlUtil.java,v 1.1 2004/03/30 12:46:42 wouthuij Exp $
 */
package mpi.library.util;


/**
 * Static methods for javax.xml
 */
/**
 * Some encoding/decoding functionality - better alternatives must be available, but I didn't have time to figure it out. Used by
 *
 * @author
 */
public class XmlUtil {
    /**
     * You cannot use characters like &amp; and &lt; in XML text.  Use this
     * function to escape the characters. This function is not contained in
     * JAXP 1.0.1
     *
     * @param s DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static String encodeXMLtext(String s) {
        if (s == null) {
            return s;
        }

        s = StringUtil.replace(s, "&", "&amp;");
        s = StringUtil.replace(s, "<", "&lt;");

        return s;
    }

    /**
     * From some &amp;xyz; encodings back to normal characters.
     *
     * @param s DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final static String decodeXMLtext(String s) {
        if (s == null) {
            return s;
        }

        s = StringUtil.replace(s, "&amp;", "&");
        s = StringUtil.replace(s, "&lt;", "<");

        return s;
    }
}
