/*
 * File:     Constraint.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.model;

import java.util.HashMap;


/**
 * Created on Aug 18, 2004
 * @author Alexander Klassmann
 * @version Aug 18, 2004
 */
public interface Constraint {
    public final static String TEMPORAL = "Search.Constraint.Temporal";
    public final static String STRUCTURAL = "Search.Constraint.Structural";
    public final static String[] MODES = { STRUCTURAL, TEMPORAL };
    public final static String ANY = "Search.Constraint.Any";
    public final static String NONE = "Search.Constraint.None";
    public final static String[] QUANTIFIERS = new String[] { ANY, NONE };
    public final static String IS_INSIDE = "Search.Constraint.Inside";
    public final static String OVERLAP = "Search.Constraint.Overlap";
    public final static String NOT_INSIDE = "Search.Constraint.NotInside";
    public final static String NO_OVERLAP = "Search.Constraint.NoOverlap";
    public final static String LEFT_OVERLAP = "Search.Constraint.LeftOverlap";
    public final static String RIGHT_OVERLAP = "Search.Constraint.RightOverlap";
    public final static String WITHIN_OVERALL_DISTANCE = "Search.Constraint.WithinOverallDistance";
    public final static String WITHIN_DISTANCE_TO_LEFT_BOUNDARY = "Search.Constraint.WithinLeftDistance";
    public final static String WITHIN_DISTANCE_TO_RIGHT_BOUNDARY = "Search.Constraint.WithinRightDistance";
    public final static String BEFORE_LEFT_DISTANCE = "Search.Constraint.BeforeLeftDistance";
    public final static String AFTER_RIGHT_DISTANCE = "Search.Constraint.AfterRightDistance";
    public final static String[] ANCHOR_CONSTRAINT_TIME_RELATIONS = {
        IS_INSIDE, OVERLAP, NOT_INSIDE, NO_OVERLAP
    };
    public final static String[] DEPENDENT_CONSTRAINT_TIME_RELATIONS = {
        IS_INSIDE, OVERLAP, LEFT_OVERLAP, RIGHT_OVERLAP, WITHIN_OVERALL_DISTANCE,
        WITHIN_DISTANCE_TO_LEFT_BOUNDARY, WITHIN_DISTANCE_TO_RIGHT_BOUNDARY,
        BEFORE_LEFT_DISTANCE, AFTER_RIGHT_DISTANCE
    };

    /** Holds value of property DOCUMENT ME! */
    public final static String regExMetaChars = "\\.^$*+?{}[]()|";

    /**
      * DOCUMENT ME!
      *
      * @param name DOCUMENT ME!
      * @param value DOCUMENT ME!
      */
    public void addAttribute(String name, String value);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public HashMap getAttributes();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getNr();

    /**
     * returns Quantifier like ("ANY" or "NONE")
     * @return String
     */
    public String getQuantifier();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getTierName();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getPattern();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getUnit();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary();

    public String getLowerBoundaryAsString();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary();

    public String getUpperBoundaryAsString();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isRegEx();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isCaseSensitive();

    public String getMode();
}
