/*
 * File:     QueryManager.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.model;

import java.util.ArrayList;
import java.util.List;


/**
 * Created on Jul 28, 2004
 * @author Alexander Klassmann
 * @version Jul 28, 2004
 */
public class QueryManager {
    final private List queries = new ArrayList();
    private int currentQueryNr = 0;

    public void addQuery(ContentQuery query) {
        queries.add(query);
        currentQueryNr = queries.size();
    }

    public boolean hasQuery() {
        return queries.size() > 0;
    }

    public boolean hasPreviousQuery() {
        return currentQueryNr > 1;
    }

    public boolean hasNextQuery() {
        return currentQueryNr < queries.size();
    }

    public ContentQuery getCurrentQuery() {
        return getQuery(currentQueryNr);
    }

    public ContentQuery getQuery(int nr) {
        return (ContentQuery) (((0 < nr) && (nr <= queries.size()))
        ? queries.get(nr - 1) : null);
    }

    public int getCurrentQueryNumber() {
        return currentQueryNr;
    }

    public void setCurrentQueryNumber(int i) {
        currentQueryNr = i;
    }

    public int size() {
        return queries.size();
    }
}
