/*
 * File:     RestrictedAnchorConstraint.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.model;

import mpi.search.content.result.model.ContentResult;


/**
 * Created on Oct 7, 2004
 * @author Alexander Klassmann
 * @version Oct 7, 2004
 */
public class RestrictedAnchorConstraint extends AnchorConstraint {
    final private ContentResult result;
    final private String comment;

    public RestrictedAnchorConstraint(ContentResult result, String comment) {
        super(1, result.getTierNames(), "", 0, 0, "", false, false, null);
        this.result = result;
        this.comment = comment;
    }

    public boolean equals(Object o) {
        return (o instanceof RestrictedAnchorConstraint) ? super.equals(o) : false;
    }

    public ContentResult getResult() {
        return result;
    }

    public String getComment() {
        return comment;
    }
}
