/*
 * File:     Utilities.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.model;

import mpi.search.content.model.CorpusType;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;


/**
 * Created on Nov 3, 2004
 *
 * @author Alexander Klassmann
 * @version Nov 3, 2004
 */
public class Utilities {
    /**
     * adapts regular expression corresponding to constraint.isRegex and
     * constraint.isCaseSensitive
     *
     * @param constraint
     * @return Pattern
     */
    static public Pattern getPattern(Constraint constraint, CorpusType type)
        throws PatternSyntaxException {
        Pattern pattern = null;
        String regex = constraint.getPattern();

        if (!constraint.isRegEx() ||
                type.isClosedVoc(constraint.getTierName())) {
            regex = escape(regex);
        }

        if (!constraint.isRegEx()) {
            if (regex.equals("")) {
                // match every non-empty 'word' (substring without spaces)
                regex = "\\b\\S+?\\b";
            } else {
                regex = "\\b" + regex + "\\b";
            }
        }

        int flag = constraint.isCaseSensitive() ? 0 : Pattern.CASE_INSENSITIVE;
        pattern = Pattern.compile(regex, flag);

        return pattern;
    }

    /**
     * Escapes all 'specialChars' in the String
     *
     * @param s
     *
     * @return String
     */
    static public String escape(String s) {
        StringBuffer escaped = new StringBuffer(s);

        for (int i = 0; i < escaped.length(); i++) {
            if (Constraint.regExMetaChars.indexOf(escaped.charAt(i)) >= 0) {
                escaped.insert(i, "\\");
                i++;
            }
        }

        return escaped.toString();
    }
}
