/*
 * File:     AbstractDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import javax.swing.JPanel;


/**
 * Created on May 26, 2004
 *
 * @author Alexander Klassmann
 * @version May 26, 2004
 */
public abstract class AbstractDistancePanel extends JPanel {
    abstract public String getUnit();

    abstract public long getLowerBoundary();

    abstract public long getUpperBoundary();

    abstract public void setUnit(String s);

    abstract public void setLowerBoundary(long lowerBoundary);

    abstract public void setUpperBoundary(long upperBoundary);

    protected long getLong(String s) {
        long l = 0;

        if (s.toUpperCase().equals("-X")) {
            l = Long.MIN_VALUE;
        } else if (s.toUpperCase().equals("X") || s.toUpperCase().equals("X")) {
            l = Long.MAX_VALUE;
        }

        try {
            l = Long.parseLong(s);
        } catch (NumberFormatException e) {
            System.out.println(SearchLocale.getString(
                    "Search.Exception.WrongNumberFormat") + ": " +
                e.getMessage());
        }

        return l;
    }

    protected String getString(long l) {
        return ((l != Long.MIN_VALUE) && (l != Long.MAX_VALUE)) ? ("" + l) : "";
    }
}
