/*
 * File:     AnchorTemporalDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.query.model.*;

import java.awt.GridBagConstraints;

import javax.swing.JComboBox;
import javax.swing.JLabel;


/**
 * Created on May 26, 2004
 * @author Alexander Klassmann
 * @version May 26, 2004
 */
public class AnchorTemporalDistancePanel extends TemporalDistancePanel {
    public AnchorTemporalDistancePanel() {
        timeRelationComboBox = new JComboBox(AnchorConstraint.ANCHOR_CONSTRAINT_TIME_RELATIONS);
        timeRelationComboBox.setRenderer(new LocalizeListCellRenderer());

        GridBagConstraints c = new GridBagConstraints();
        add(new JLabel(SearchLocale.getString("Search.And") + " "), c);
        add(timeRelationComboBox, c);
        add(new JLabel(" " + SearchLocale.getString("Search.Interval") + " " +
                SearchLocale.getString("Search.From")), c);
        add(fromTimeField, c);
        add(new JLabel(SearchLocale.getString("Search.To")));
        add(toTimeField, c);
    }
}
