/*
 * File:     DependentTemporalDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.query.model.*;

import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.event.*;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Created on May 26, 2004
 * @author Alexander Klassmann
 * @version May 26, 2004
 */
public class DependentTemporalDistancePanel extends TemporalDistancePanel
    implements ItemListener {
    final private CardLayout distanceLayout = new CardLayout();
    final private JPanel distancePanel = new JPanel(distanceLayout);

    public DependentTemporalDistancePanel() {
        timeRelationComboBox = new JComboBox(AnchorConstraint.DEPENDENT_CONSTRAINT_TIME_RELATIONS);
        timeRelationComboBox.setRenderer(new LocalizeListCellRenderer());

        distancePanel.add(toTimeField, "distance");
        distancePanel.add(new JLabel(""), "");

        GridBagConstraints c = new GridBagConstraints();
        add(new JLabel(SearchLocale.getString("Search.And") + " "), c);
        add(timeRelationComboBox, c);
        add(distancePanel);
        timeRelationComboBox.addItemListener(this);
        timeRelationComboBox.setSelectedIndex(0);
        checkDistancePanel();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED) {
            checkDistancePanel();
        }
    }

    private void checkDistancePanel() {
        Object selectedItem = timeRelationComboBox.getSelectedItem();

        if (Constraint.WITHIN_OVERALL_DISTANCE.equals(selectedItem) ||
                Constraint.WITHIN_DISTANCE_TO_LEFT_BOUNDARY.equals(selectedItem) ||
                Constraint.WITHIN_DISTANCE_TO_RIGHT_BOUNDARY.equals(
                    selectedItem) ||
                Constraint.BEFORE_LEFT_DISTANCE.equals(selectedItem) ||
                Constraint.AFTER_RIGHT_DISTANCE.equals(selectedItem)) {
            distanceLayout.show(distancePanel, "distance");
        } else {
            distanceLayout.show(distancePanel, "");
        }
    }
}
