/*
 * File:     LocalizeListCellRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;


/**
 * Created on Jun 23, 2004
 * @author Alexander Klassmann
 * @version Jun 23, 2004
 */
public class LocalizeListCellRenderer extends DefaultListCellRenderer {
    /* (non-Javadoc)
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    public Component getListCellRendererComponent(JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus) {
        String valueString = null;

        if (value != null) {
            valueString = value.toString();

            String localizedValueString = SearchLocale.getString(valueString);

            if ((localizedValueString != null) &&
                    (localizedValueString.length() > 0)) {
                valueString = localizedValueString;
            }
        }

        return super.getListCellRendererComponent(list, valueString, index,
            isSelected, cellHasFocus);
    }
}
