/*
 * File:     RelationPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.Constraint;

import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Created on Jul 14, 2004
 * @author Alexander Klassmann
 * @version November 2004
 */
public class RelationPanel extends JPanel {
    final private CardLayout distanceInputLayout = new CardLayout();
    final private JPanel distancePanelPlaceHolder = new JPanel(distanceInputLayout);
    protected AbstractDistancePanel temporalDistancePanel;
    protected AbstractDistancePanel structuralDistancePanel;

    /** Holds value of property DOCUMENT ME! */
    final protected JComboBox referenceConstraintComboBox = new JComboBox();

    /** Holds value of property DOCUMENT ME */
    final protected JComboBox quantifierComboBox = new JComboBox(Constraint.QUANTIFIERS);

    protected RelationPanel(final QueryPanel queryPanel, CorpusType type,
        int constraintNr) {
        setLayout(new GridBagLayout());

        GridBagConstraints c = new GridBagConstraints();

        if (constraintNr == 1) {
            temporalDistancePanel = new AnchorTemporalDistancePanel();
        } else {
            temporalDistancePanel = new DependentTemporalDistancePanel();
        }

        structuralDistancePanel = new StructuralDistancePanel();
        distancePanelPlaceHolder.add(structuralDistancePanel,
            Constraint.STRUCTURAL);
        distancePanelPlaceHolder.add(temporalDistancePanel, Constraint.TEMPORAL);

        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = GridBagConstraints.RELATIVE;
        c.fill = GridBagConstraints.NONE;

        add(distancePanelPlaceHolder, c);

        c.anchor = GridBagConstraints.WEST;

        if (constraintNr > 1) {
            add(new JLabel(SearchLocale.getString(
                        "Search.Constraint.MatchesFoundIn") + " "), c);

            for (int j = 1; j < constraintNr; j++) {
                referenceConstraintComboBox.addItem(new Integer(j));
            }

            referenceConstraintComboBox.setSelectedIndex(0);

            if (constraintNr == 2) {
                add(new JLabel("1  "), c);
            } else {
                add(referenceConstraintComboBox, c);
            }
        }

        referenceConstraintComboBox.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == ItemEvent.SELECTED) {
                        queryPanel.notifyOtherConstraints(getRefConstraintNr());
                    }
                }
            });

        if ((constraintNr == 1) && !type.allowsTemporalConstraints()) {
            setVisible(false);
        } else {
            setDistanceMode(Constraint.TEMPORAL);
        }
    }

    /**
     * Fills the unitComboBox with all SearchUnits which share the tier on this
     * constraint and the tier of the constraint it refers to
     */
    public JComboBox getUnitComboBox() {
        return ((StructuralDistancePanel) structuralDistancePanel).getUnitComboBox();
    }

    public void setDistanceMode(String mode) {
        distanceInputLayout.show(distancePanelPlaceHolder, mode);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary() {
        return ((!isVisible() || temporalDistancePanel.isVisible())
        ? temporalDistancePanel : structuralDistancePanel).getLowerBoundary();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary() {
        return ((!isVisible() || temporalDistancePanel.isVisible())
        ? temporalDistancePanel : structuralDistancePanel).getUpperBoundary();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public void setLowerBoundary(long boundary) {
        (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                           : structuralDistancePanel).setLowerBoundary(boundary);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public void setUpperBoundary(long boundary) {
        (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                           : structuralDistancePanel).setUpperBoundary(boundary);
    }

    /**
    * DOCUMENT ME!
    *
    * @return DOCUMENT ME!
    */
    public String getUnit() {
        return (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                                  : structuralDistancePanel).getUnit();
    }

    public void setUnit(String unit) {
        (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                           : structuralDistancePanel).setUnit(unit);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getRefConstraintNr() {
        return (referenceConstraintComboBox.getItemCount() == 0) ? (-1)
                                                                 : ((Integer) referenceConstraintComboBox.getSelectedItem()).intValue();
    }

    /**
     * DOCUMENT ME!
     *
     * @param c DOCUMENT ME!
     */
    public void setRefConstraintNr(int refConstraint) {
        if (refConstraint > 0) {
            referenceConstraintComboBox.setSelectedItem(new Integer(
                    refConstraint));
        }
    }
}
