/*
 * File:     RestrictedAnchorConstraintPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;

import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.SwingConstants;


/**
 * Created on Oct 8, 2004
 * @author Alexander Klassmann
 * @version Oct 8, 2004
 */
public class RestrictedAnchorConstraintPanel extends AnchorConstraintPanel {
    final private JLabel restrictedLabel = new JLabel("Matches from current result",
            SwingConstants.CENTER);
    final private RestrictedAnchorConstraint constraint;

    public RestrictedAnchorConstraintPanel(QueryPanel parentPanel, Font font,
        CorpusType type, RestrictedAnchorConstraint constraint) {
        super(parentPanel, font, type);

        this.constraint = constraint;
        setTierNames(constraint.getTierNames());
        restrictedLabel.setText(constraint.getComment());
        makeLayout();
        framedPanel.add(restrictedLabel, "restricted");
        framedPanelLayout.show(framedPanel, "restricted");
    }

    public void setConstraint(AnchorConstraint constraint) {
        //should never be called
    }

    public String[] getTierNames() {
        //returns only the tierNames present in result; call to superclass method would return all
        return constraint.getTierNames();
    }

    public AnchorConstraint getConstraint() {
        return constraint;
    }
}
