/*
 * File:     StructuralDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.util.gui.XNumericalJTextFieldFilter;

import java.awt.*;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;


/**
 * Created on May 20, 2004
 *
 * @author Alexander Klassmann
 * @version May 20, 2004
 */
public class StructuralDistancePanel extends AbstractDistancePanel {
    private static int unitComboBoxWidth = 160;

    /** Holds value of property DOCUMENT ME! */
    final private JTextField fromTextField = new JTextField(new XNumericalJTextFieldFilter(
                XNumericalJTextFieldFilter.INTEGER_WITH_NEG_INFINITY), "0", 3);

    /** Holds value of property DOCUMENT ME! */
    final private JTextField toTextField = new JTextField(new XNumericalJTextFieldFilter(
                XNumericalJTextFieldFilter.INTEGER_WITH_POS_INFINITY), "0", 3);

    /** Holds value of property DOCUMENT ME! */
    final protected JComboBox unitComboBox;

    public StructuralDistancePanel() {
        fromTextField.setHorizontalAlignment(JTextField.CENTER);
        toTextField.setHorizontalAlignment(JTextField.CENTER);

        setLayout(new GridBagLayout());

        GridBagConstraints c = new GridBagConstraints();
        unitComboBox = new JComboBox() {
                    public Dimension getPreferredSize() {
                        return new Dimension(unitComboBoxWidth,
                            super.getPreferredSize().height);
                    }
                };

        add(new JLabel(SearchLocale.getString("Search.Constraint.Distance") +
                " "), c);
        add(fromTextField, c);
        add(new JLabel(" " + SearchLocale.getString("Search.To") + " "), c);
        add(toTextField, c);
        add(new JLabel(" "), c);
        add(unitComboBox, c);
        add(new JLabel(" " + SearchLocale.getString("Search.From") + " "), c);
    }

    public JComboBox getUnitComboBox() {
        return unitComboBox;
    }

    public void setUnitComboBoxRenderer(ListCellRenderer renderer) {
        unitComboBox.setRenderer(renderer);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary() {
        return fromTextField.getText().trim().equals("") ? Long.MIN_VALUE
                                                         : getLong(fromTextField.getText());
    }

    /**
     * DOCUMENT ME!
     *
     * @param lb
     *            DOCUMENT ME!
     */
    public void setLowerBoundary(long l) {
        fromTextField.setText(getString(l));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary() {
        return toTextField.getText().trim().equals("") ? Long.MAX_VALUE
                                                       : getLong(toTextField.getText());
    }

    /**
     * DOCUMENT ME!
     *
     * @param ub
     *            DOCUMENT ME!
     */
    public void setUpperBoundary(long l) {
        toTextField.setText(getString(l));
    }

    public String getUnit() {
        return (unitComboBox.getSelectedIndex() != -1)
        ? (String) unitComboBox.getSelectedItem() : "";
    }

    public void setUnit(String s) {
        unitComboBox.setSelectedItem(s);
    }
}
