/*
 * File:     TemporalDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.viewer;

import java.awt.*;

import javax.swing.JComboBox;


/**
 * Created on May 19, 2004
 *
 * @author Alexander Klassmann
 * @version May 19, 2004
 */
public class TemporalDistancePanel extends AbstractDistancePanel {
    protected JComboBox timeRelationComboBox;

    /** Holds value of property DOCUMENT ME! */
    final protected TimeField fromTimeField = new TimeField(false);

    /** Holds value of property DOCUMENT ME! */
    final protected TimeField toTimeField = new TimeField(true);

    public TemporalDistancePanel() {
        setLayout(new GridBagLayout());
    }

    public long getLowerBoundary() {
        return fromTimeField.getTime();
    }

    public long getUpperBoundary() {
        return toTimeField.getTime();
    }

    public String getUnit() {
        return (timeRelationComboBox.getSelectedIndex() != -1)
        ? (String) timeRelationComboBox.getSelectedItem() : "";
    }

    public void setLowerBoundary(long milliSeconds) {
        fromTimeField.setTime(milliSeconds);
    }

    public void setUpperBoundary(long milliSeconds) {
        toTimeField.setTime(milliSeconds);
    }

    public void setUnit(String unit) {
        timeRelationComboBox.setSelectedItem(unit);
    }
}
