/*
 * File:     QueryContentHandler.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.query.xml;

import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.DependentConstraint;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import java.util.ArrayList;
import java.util.List;


/**
 * Created on Sep 30, 2004
 * @author Alexander Klassmann
 * @version Sep 30, 2004
 */
public class QueryContentHandler implements ContentHandler {
    private final ContentQuery query;
    private String mode;
    private String quantifier;
    private List tierNames = new ArrayList();
    private String pattern;
    private boolean isRegEx;
    private boolean isCaseSensitive;
    private long lowerBoundary;
    private long upperBoundary;
    private String unit;
    private int nr;
    private int reference;
    private int dependentConstraintNr = 2;
    private String currentContent;

    protected QueryContentHandler(ContentQuery query) {
        this.query = query;
    }

    /**
     *
     * @param locator <description>
     */
    public void setDocumentLocator(Locator locator) {
    }

    /**
     *
     * @exception org.xml.sax.SAXException <description>
     */
    public void startDocument() throws SAXException {
        System.out.println("Start parsing query file.");
    }

    /**
     *
     * @exception org.xml.sax.SAXException <description>
     */
    public void endDocument() throws SAXException {
        System.out.println("End parsing query file.");
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void startPrefixMapping(String param1, String param2)
        throws SAXException {
    }

    /**
     *
     * @param param1 <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void endPrefixMapping(String param1) throws SAXException {
    }

    /**
     * resets defaults for (Abstract)-constraint
     *
     */
    private void resetConstraintFields() {
        tierNames.clear();
        pattern = "";
        isRegEx = false;
        isCaseSensitive = false;
        unit = "";
        lowerBoundary = Long.MIN_VALUE;
        upperBoundary = Long.MAX_VALUE;
    }

    /**
     * @param namespaceURI <description>
     * @param elementName <description>
     * @param rawName <description>
     * @param atts <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void startElement(String namespaceURI, String elementName,
        String rawName, Attributes atts) throws SAXException {
        if (elementName.equals("anchorConstraint")) {
            resetConstraintFields();
            nr = 1;

            String s;
            s = atts.getValue("id");

            if (s != null) {
                try {
                    nr = Integer.parseInt(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }

            s = atts.getValue("regularExpression");

            if (s != null) {
                isRegEx = Boolean.valueOf(s).booleanValue();
            }

            s = atts.getValue("caseSensitive");

            if (s != null) {
                isCaseSensitive = Boolean.valueOf(s).booleanValue();
            }

            s = atts.getValue("unit");

            if (s != null) {
                unit = s;
            }

            s = atts.getValue("from");

            if (s != null) {
                try {
                    lowerBoundary = Long.parseLong(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }

            s = atts.getValue("to");

            if (s != null) {
                try {
                    upperBoundary = Long.parseLong(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }
        } else if (elementName.equals("dependentConstraint")) {
            resetConstraintFields();
            nr = dependentConstraintNr;
            mode = Constraint.TEMPORAL;
            quantifier = Constraint.ANY;
            reference = 1;

            String s;
            s = atts.getValue("id");

            if (s != null) {
                try {
                    nr = Integer.parseInt(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }

            s = atts.getValue("mode");

            if (s != null) {
                mode = s;
            }

            s = atts.getValue("quantifier");

            if (s != null) {
                quantifier = s;
            }

            s = atts.getValue("regularExpression");

            if (s != null) {
                isRegEx = Boolean.valueOf(s).booleanValue();
            }

            s = atts.getValue("caseSensitive");

            if (s != null) {
                isCaseSensitive = Boolean.valueOf(s).booleanValue();
            }

            s = atts.getValue("unit");

            if (s != null) {
                unit = s;
            }

            s = atts.getValue("from");

            if (s != null) {
                try {
                    lowerBoundary = Long.parseLong(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }

            s = atts.getValue("to");

            if (s != null) {
                try {
                    upperBoundary = Long.parseLong(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }

            s = atts.getValue("id_ref");

            if (s != null) {
                try {
                    reference = Integer.parseInt(s);
                } catch (NumberFormatException ne) {
                    if (!ne.getMessage().equals("null")) {
                        System.out.println(ne.getMessage());
                    }
                }
            }
        }

        currentContent = "";
    }

    /**
     * @param namespaceURI <description>
     * @param elementName <description>
     * @param rawName <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void endElement(String namespaceURI, String elementName,
        String rawName) throws SAXException {
        if (elementName.equals("tier")) {
            tierNames.add(currentContent);
        } else if (elementName.equals("pattern")) {
            pattern = currentContent;
        } else if (elementName.equals("anchorConstraint")) {
            AnchorConstraint constraint = new AnchorConstraint(nr,
                    (String[]) tierNames.toArray(new String[0]), pattern,
                    lowerBoundary, upperBoundary, unit, isRegEx,
                    isCaseSensitive, null);
            query.setAnchorConstraint(constraint);
        } else if (elementName.equals("dependentConstraint")) {
            DependentConstraint constraint = new DependentConstraint(nr,
                    reference, quantifier, (String) tierNames.get(0), pattern,
                    mode, lowerBoundary, upperBoundary, unit, isRegEx,
                    isCaseSensitive, null);
            query.addDependentConstraint(constraint);
            dependentConstraintNr++;
        }
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @param param3 <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void characters(char[] ch, int start, int end)
        throws SAXException {
        currentContent += new String(ch, start, end);
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @param param3 <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void ignorableWhitespace(char[] param1, int param2, int param3)
        throws SAXException {
    }

    /**
     *
     * @param param1 <description>
     * @param param2 <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void processingInstruction(String param1, String param2)
        throws SAXException {
    }

    /**
     *
     * @param param1 <description>
     * @exception org.xml.sax.SAXException <description>
     */
    public void skippedEntity(String param1) throws SAXException {
    }
}
