/*
 * File:     ContentMatch2TabDelimitedText.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.result.model;

import mpi.eudico.client.util.Transcription2TabDelimitedText;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import java.util.List;


public class ContentMatch2TabDelimitedText {
    /**
    * Exports a List of Matches to Tab limited text (as exportAnnotations, but
    * with file name of match)
    *
    * @param matches
    * @param exportFile
    *
    * @throws IOException
    */
    static public void exportMatches(List matches, File exportFile)
        throws IOException {
        if (exportFile == null) {
            return;
        }

        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out,
                    "UTF-8"));

        for (int i = 0; i < matches.size(); i++) {
            if (matches.get(i) instanceof ContentMatch) {
                ContentMatch match = (ContentMatch) matches.get(i);

                if (!"".equals(match.getFileName())) {
                    writer.write(match.getFileName() +
                        Transcription2TabDelimitedText.TAB);
                }

                writer.write(match.getTierName() +
                    Transcription2TabDelimitedText.getTabString(match));
            }
        }

        writer.close();
    }
}
