/*
 * File:     ExampleMatch.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.content.result.model;


/**
 * Created on Jul 30, 2004
 * @author Alexander Klassmann
 * @version Jul 30, 2004
 */
public class ExampleMatch implements ContentMatch {
    public long getBeginTimeBoundary() {
        return 1234L;
    }

    public long getEndTimeBoundary() {
        return 9876L;
    }

    public String getValue() {
        return "This is an example value!";
    }

    public String getTierName() {
        return "ExampleTier1";
    }

    public String getFileName() {
        return "No file name yet";
    }

    public String getLeftContext() {
        return "Some left context";
    }

    public String getRightContext() {
        return "Some right context";
    }

    public int getIndex() {
        return 1;
    }

    public int[][] getMatchedSubstringIndices() {
        return new int[][] {
            { 9, 15 }
        };
    }

    public String getId() {
        return "007";
    }
}
