/*
 * File:     ContentMatchCounter.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.search.content.result.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.result.model.ContentResult;

import mpi.search.viewer.MatchCounter;

import javax.swing.SwingConstants;


/**
 * $Id: ContentMatchCounter.java,v 1.4 2005/08/09 13:04:35 klasal Exp $
 * $Author: klasal $ $Version$
 */
public class ContentMatchCounter extends MatchCounter {
    /**
     * Creates a new MatchCounter object.
     */
    public ContentMatchCounter() {
        setHorizontalAlignment(SwingConstants.CENTER);
        render();
    }

    /**
     * DOCUMENT ME!
     */
    public void render() {
        StringBuffer text = new StringBuffer();

        if (result != null) {
            if (result instanceof ContentResult) {
                text.append(((ContentResult) result).getOccurrenceCount() +
                    " " +
                    SearchLocale.getString((((ContentResult) result).getOccurrenceCount() == 1)
                        ? "Search.Occurrence_SG" : "Search.Occurrence_PL") +
                    " in ");

                text.append(result.getMatchCount() + " " +
                    SearchLocale.getString((result.getMatchCount() == 1)
                        ? "Search.Annotation_SG" : "Search.Annotation_PL"));
            } else {
                text.append(result.getMatchCount() + " matches");
            }
        }

        setText(text.toString());
    }
}
