/*
 * File:     Result.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.search.model;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;


/**
 * Created on Apr 15, 2005 $Id: Result.java,v 1.4 2005/07/15 13:16:27 klasal Exp $ $Author: klasal
 * $ $Version$
 */
public class Result {
    private static final int DEFAULT_CHUNK_SIZE = 50;

    /** DOCUMENT ME! */
    public static final int MODIFIED = 2;

    /** DOCUMENT ME! */
    public static final int COMPLETE = 1;

    /** DOCUMENT ME! */
    public static final int INIT = 0;

    /** DOCUMENT ME! */
    public static final int INTERRUPTED = -1;

    /** DOCUMENT ME! */
    protected int chunkSize;

    /** DOCUMENT ME! */
    protected int status = INTERRUPTED;
    private final List listeners = new ArrayList();
    private final List matches = new ArrayList();

    /**
     * Creates a new Result object.
     */
    public Result() {
        this(DEFAULT_CHUNK_SIZE);
    }

    /**
     * Creates a new Result object.
     *
     * @param chunkSize DOCUMENT ME!
     */
    public Result(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    /**
     * DOCUMENT ME!
     *
     * @param status DOCUMENT ME!
     */
    public final void setStatus(int status) {
        if (this.status != status) {
            this.status = status;
            notifyListeners(new ResultEvent(this, ResultEvent.STATUS_CHANGED));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final int getStatus() {
        return status;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Match getLastMatch() {
        return (Match) ((matches.size() > 0) ? matches.get(matches.size() - 1)
                                             : null);
    }

    /**
     * DOCUMENT ME!
     *
     * @param i DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Match getMatch(int i) {
        return (Match) (((0 < i) && (i <= matches.size())) ? matches.get(i - 1)
                                                           : null);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getMatchCount() {
        return matches.size();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public List getMatches() {
        return matches;
    }

    /**
     * DOCUMENT ME!
     *
     * @param match DOCUMENT ME!
     */
    public void addMatch(Match match) {
        matches.add(match);

        if (matches.size() <= chunkSize) {
            notifyListeners(new ResultEvent(this, ResultEvent.MATCH_ADDED));
        } else if ((matches.size() % chunkSize) == 0) {
            notifyListeners(new ResultEvent(this, ResultEvent.STATUS_CHANGED));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param listener DOCUMENT ME!
     */
    public void addResultChangeListener(ResultChangeListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            listener.resultChanged(new ResultEvent(this,
                    ResultEvent.STATUS_CHANGED));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void notifyListeners(ResultEvent event) {
        try {
            for (Iterator iter = listeners.iterator(); iter.hasNext();) {
                ((ResultChangeListener) iter.next()).resultChanged(event);
            }
        } catch (ConcurrentModificationException e) {
            //ignore
            System.out.println("Concurrent modification exception - ignored");
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void removeListeners() {
        listeners.clear();
    }

    /**
     * DOCUMENT ME!
     */
    public void reset() {
        matches.clear();
        status = INIT;
        notifyListeners(new ResultEvent(this, ResultEvent.STATUS_CHANGED));
    }
}
