/*
 * File:     SearchController.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.model;


/**
 * DOCUMENT ME!
 *
 * @author Alexander Klassmann
 * @version July 2004
 */
public interface SearchController {
    static public int INIT = 0;
    static public int ACTIVE = 1;
    static public int FINISHED = 2;
    static public int INTERRUPTED = 3;

    /**
     * Execute a query tree on behalf of forQManager.
     * @param query
     */
    public void execute(Query query);

    /**
     * returns true if in process of searching
     * @return
     */
    public boolean isExecuting();

    /**
     * Stop searching.
     */
    public void stopExecution();

    /**
     * Returns result. Contains all matches found until stopped.
     * @return Result
     */
    public Result getResult();

    /**
     * set a GUI for showing progress of search
     * @param o
     */
    public void setProgressListener(ProgressListener o);

    /**
     * get current search duration
     * @return
     */
    public long getSearchDuration();
}
