/*
 * File:     SearchListener.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.model;


/**
 * Created on Jul 28, 2004
 * @author Alexander Klassmann
 * @version April, 2005
 */
public interface SearchListener {
    /**
     * Handle exceptions from search thread
     * @param e
     */
    public void handleException(Exception e);

    /**
     * notifies tool that search has started
     *
     */
    public void executionStarted();

    /**
     * notifies tool that search has stopped
     *
     */
    public void executionStopped();
}
