/*
 * File:     AbstractSearchPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.viewer;

import mpi.search.model.Query;
import mpi.search.model.SearchController;
import mpi.search.model.SearchListener;

import javax.swing.JFrame;
import javax.swing.JPanel;


/**
 * Created on Apr 14, 2005
 * $Id: AbstractSearchPanel.java,v 1.5 2005/11/01 16:07:16 klasal Exp $
 *
 * $Author: klasal $
 * $Version$
 */
abstract public class AbstractSearchPanel extends JPanel
    implements SearchListener {
    /** search engine */
    protected SearchController searchEngine;

    /** Holds value of property DOCUMENT ME! */
    protected ResultViewer resultViewer;

    /** progress viewer */
    protected final ProgressViewer progressViewer;

    /** show current number of result and amount of matches */
    protected MatchCounter matchCounter;

    public AbstractSearchPanel() {
        progressViewer = new ProgressViewer();
        matchCounter = new MatchCounter();
    }

    protected void startSearch() {
        Query query = getQuery();

        if (query != null) {
            query.getResult().reset();

            query.getResult().addResultChangeListener(matchCounter);
            query.getResult().addResultChangeListener(resultViewer);

            searchEngine.execute(query);
        }
    }

    public void stopSearch() {
        if (searchEngine != null) {
            searchEngine.stopExecution();
        }
    }

    public void executionStarted() {
        matchCounter.setVisible(true);
        progressViewer.setVisible(true);
    }

    public void executionStopped() {
        searchEngine.getResult().removeListeners();
    }

    abstract protected Query getQuery();
}
