/*
 * File:     MatchCounter.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.viewer;

import mpi.search.model.Result;
import mpi.search.model.ResultChangeListener;
import mpi.search.model.ResultEvent;

/**
 * Created on May 3, 2005
 * $Id: MatchCounter.java,v 1.8 2005/07/19 13:21:09 klasal Exp $
 *
 * $Author: klasal $
 * $Version$
 */
import javax.swing.JLabel;


public class MatchCounter extends JLabel implements ResultChangeListener {
    protected Result result;

    /**
      * DOCUMENT ME!
      *
      * @param e
      *            DOCUMENT ME!
      */
    public void resultChanged(ResultEvent e) {
        setResult((Result) e.getSource());
    }

    /**
     * DOCUMENT ME!
     *
     * @param result
     *            DOCUMENT ME!
     */
    public void setResult(Result result) {
        this.result = result;
        render();
    }

    /**
     * DOCUMENT ME!
     */
    public void render() {
        setText(result.getMatchCount() + " matches");
    }
}
