/*
 * File:     ProgressViewer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.search.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.result.model.ContentResult;

import mpi.search.model.ProgressListener;
import mpi.search.model.Result;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;


/**
 * Created on Sep 23, 2004
 *
 * @author Alexander Klassmann
 * @version December, 2004
 */
public class ProgressViewer extends JProgressBar implements ProgressListener {
    final private String interrupted = "Search.Interrupted";
    final private String complete = "Search.Complete";
    final private String modified = "Search.Modified";

    public ProgressViewer() {
        setBorder(new LineBorder(Color.lightGray));
        setStringPainted(true);
        setProgress(0);
        setVisible(false);
    }

    public void setProgress(int procent) {
        setVisible(true);
        setValue(procent);

        if (procent == 0) {
            setString(" "); // empty string results in height change
        } else {
            setString((procent < 100) ? (procent + "%")
                                      : SearchLocale.getString(complete));
        }
    }

    public void setStatus(int status) {
        setVisible(true);

        switch (status) {
        case Result.COMPLETE:
            setValue(100);
            setString(SearchLocale.getString(complete));

            break;

        case Result.INTERRUPTED:
            setValue(0);
            setString(SearchLocale.getString(interrupted));

            break;

        case ContentResult.MODIFIED:
            setValue(0);
            setString(SearchLocale.getString(modified));
        }
    }

    // don't let shrink
    public Dimension getMinimumSize() {
        return getPreferredSize();
    }
}
