/*
 * File:     CVentry.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.util;


/**
 * class CVentry implements the functions  of a Controlled Vocabulary item
 * there is a tag to show in a menu, a value and a description
 */
public class CVentry implements DescriptedObject {
    /** Holds value of property DOCUMENT ME! */
    String value;

    /** Holds value of property DOCUMENT ME! */
    String tag;

    /** Holds value of property DOCUMENT ME! */
    String followup;

    /** Holds value of property DOCUMENT ME! */
    String description;

    /**
     * Creates a new CVentry instance
     *
     * @param tag DOCUMENT ME!
     * @param value DOCUMENT ME!
     * @param followup DOCUMENT ME!
     * @param description DOCUMENT ME!
     */
    public CVentry(String tag, String value, String followup, String description) {
        this.value = value;
        this.tag = tag;
        this.followup = followup;
        this.description = description;
    }

    /**
     * Creates a new CVentry instance
     *
     * @param value DOCUMENT ME!
     * @param description DOCUMENT ME!
     */
    public CVentry(String value, String description) {
        this.value = value;

        int start = value.lastIndexOf('/') + 1;
        int end = value.lastIndexOf(".xml");

        if (end > 0) {
            tag = value.substring(start, end);
        } else {
            tag = value;
        }

        this.description = description;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getValue() {
        return value;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return tag;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDescription() {
        return description;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getFollowUp() {
        return followup;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return tag;
    }
}
