/*
 * File:     ExplicativeJComboBox.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.util.gui;

import mpi.util.DescriptedObject;

import java.awt.Component;

import java.util.Vector;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ToolTipManager;


/**
 * ExplicativeJComboBox class is a JComboBox with added functionality of offering a tooltip with
 * every menu item.
 */
public class ExplicativeJComboBox extends JComboBox {
    /**
     * Creates a new ExplicativeJComboBox instance
     *
     * @param items DOCUMENT ME!
     */
    public ExplicativeJComboBox(Vector items) {
        super(items);
        initBox();
    }

    /**
     * Creates a new ExplicativeJComboBox instance
     */
    public ExplicativeJComboBox() {
        initBox();
    }

    /**
         *
         */
    private void initBox() {
        ToolTipManager.sharedInstance().registerComponent(this);
        setRenderer(new MyListCellRenderer());
        setEditor(new ExplicativeJComboBoxEditor(this));
    }

    /**
     * DOCUMENT ME! $Id: ExplicativeJComboBox.java,v 1.2 2005/09/29 09:32:13 klasal Exp $
     *
     * @author $Author: klasal $
     * @version $Revision: 1.2 $
     */
    public class MyListCellRenderer extends DefaultListCellRenderer {
        /**
         * Creates a new MyListCellRenderer instance
         */
        MyListCellRenderer() {
            setOpaque(true);
        }

        /**
         * DOCUMENT ME!
         *
         * @param list DOCUMENT ME!
         * @param value DOCUMENT ME!
         * @param index DOCUMENT ME!
         * @param isSelected DOCUMENT ME!
         * @param celHasFocus DOCUMENT ME!
         *
         * @return DOCUMENT ME!
         */
        public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean celHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected,
                celHasFocus);

            if (isSelected) {
                if (value instanceof DescriptedObject) {
                    DescriptedObject descrobj = (DescriptedObject) value;
                    list.setToolTipText(descrobj.getDescription());
                    ExplicativeJComboBox.this.setToolTipText(descrobj.getDescription());
                } else {
                    list.setToolTipText(null);
                    ExplicativeJComboBox.this.setToolTipText(null);
                }
            }

            setText(value.toString());

            return this;
        }
    }
}
