/*
 * File:     ExplicativeJComboBoxEditor.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.util.gui;

import mpi.util.CVentry;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;


/**
 * DOCUMENT ME! $Id: ExplicativeJComboBoxEditor.java,v 1.2 2005/09/29 09:32:13 klasal Exp $
 *
 * @author $Author: klasal $
 * @version $Revision: 1.2 $
 */
class ExplicativeJComboBoxEditor extends BasicComboBoxEditor {
    /**
         *
         */
    private final ExplicativeJComboBox box;

    /** Holds value of property DOCUMENT ME! */
    private CVentry _entry = null;

    /** Holds value of property DOCUMENT ME! */
    private final JTextField _textField;

    /** avoid endless loops of update */
    private boolean doNotListen = false;

    /**
     * Creates a new MyComboBoxEditor instance
     *
     * @param box TODO
     */
    public ExplicativeJComboBoxEditor(ExplicativeJComboBox box) {
        super();
        this.box = box;
        _textField = new JTextField();
        _textField.setColumns(12);

        //update after every change in textfield, not only after RETURN
        _textField.getDocument().addDocumentListener(new DocumentListener() {
                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    updateComboBox();
                }

                public void removeUpdate(DocumentEvent e) {
                    updateComboBox();
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public java.awt.Component getEditorComponent() {
        return _textField;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     */
    public void setItem(final Object obj) {
        _entry = (CVentry) obj;

        if (!doNotListen) {
            _textField.setText(_entry.toString());
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object getItem() {
        if ((_entry == null) || _entry.toString().equals(_textField.getText())) {
            return _entry;
        }

        return new CVentry(_textField.getText(), "");
    }

    /**
         *
         */
    private void updateComboBox() {
        if (getItem() != null) {
            doNotListen = true;
            this.box.setSelectedItem(getItem());
            doNotListen = false;
        }
    }
}
