/*
 * File:     SteppedComboBox.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.util.gui;

import java.awt.Dimension;
import java.awt.Rectangle;

import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;


/**
 * SteppedComboBox is a ComboBox with fixed size of title item, but variable
 * size of the PopupMenu
 *
 * @version 1.0 12/12/98
 */
public class SteppedComboBox extends JComboBox {
    /** Holds value of property DOCUMENT ME! */
    protected int popupWidth;

    /**
     * Creates a new SteppedComboBox instance
     *
     * @param aModel DOCUMENT ME!
     */
    public SteppedComboBox(ComboBoxModel aModel) {
        super(aModel);
        setUI(new SteppedComboBoxUI());
        popupWidth = 0;
    }

    /**
     * Creates a new SteppedComboBox instance
     *
     * @param items DOCUMENT ME!
     */
    public SteppedComboBox(final Object[] items) {
        super(items);
        setUI(new SteppedComboBoxUI());
        popupWidth = 0;
    }

    /**
     * Creates a new SteppedComboBox instance
     *
     * @param items DOCUMENT ME!
     */
    public SteppedComboBox(Vector items) {
        super(items);
        setUI(new SteppedComboBoxUI());
        popupWidth = 0;
    }

    /**
     * Creates a new SteppedComboBox instance
     */
    public SteppedComboBox() {
        super();
        setUI(new SteppedComboBoxUI());
        popupWidth = 0;
    }

    /**
     * DOCUMENT ME!
     *
     * @param width DOCUMENT ME!
     */
    public void setPopupWidth(int width) {
        popupWidth = width;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Dimension getPopupSize() {
        Dimension size = getSize();

        if (popupWidth < 1) {
            popupWidth = size.width;
        }

        return new Dimension(popupWidth, size.height);
    }
}


/**
 * DOCUMENT ME!
 * $Id: SteppedComboBox.java,v 1.1 2005/08/10 15:25:05 klasal Exp $
 * @author $Author: klasal $
 * @version $Revision: 1.1 $
 */
class SteppedComboBoxUI extends MetalComboBoxUI {
    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected ComboPopup createPopup() {
        BasicComboPopup popup = new BasicComboPopup(comboBox) {
                public void show() {
                    Dimension popupSize = ((SteppedComboBox) comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width,
                        getPopupHeightForRowCount(comboBox.getMaximumRowCount()));

                    Rectangle popupBounds = computePopupBounds(0,
                            comboBox.getBounds().height, popupSize.width,
                            popupSize.height);
                    scroller.setMaximumSize(popupBounds.getSize());
                    scroller.setPreferredSize(popupBounds.getSize());
                    scroller.setMinimumSize(popupBounds.getSize());
                    list.invalidate();

                    int selectedIndex = comboBox.getSelectedIndex();

                    if (selectedIndex == -1) {
                        list.clearSelection();
                    } else {
                        list.setSelectedIndex(selectedIndex);
                    }

                    list.ensureIndexIsVisible(list.getSelectedIndex());
                    setLightWeightPopupEnabled(comboBox.isLightWeightPopupEnabled());

                    show(comboBox, popupBounds.x, popupBounds.y);
                }
            };

        popup.getAccessibleContext().setAccessibleParent(comboBox);

        return popup;
    }
}
