/*
 * File:     TreeFrame.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.WindowConstants;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;


/**
 * DOCUMENT ME! $Id: TreeFrame.java,v 1.1 2005/08/10 15:32:45 klasal Exp $
 *
 * @author $Author: klasal $
 * @version $Revision: 1.1 $
 */
public class TreeFrame extends JFrame {
    /** Holds value of property DOCUMENT ME! */
    private final JTree tree;
    private DefaultTreeCellRenderer renderer;

    /**
     * Creates a new TreeFrame instance
     *
     * @param treeNode
     *            DOCUMENT ME!
     * @param bDefaultCloseOperation
     *            DOCUMENT ME!
     */
    public TreeFrame(TreeNode treeNode) {
        this(treeNode, false);
    }

    /**
     * Creates a new TreeFrame instance
     *
     * @param treeNode
     *            DOCUMENT ME!
     */
    public TreeFrame(TreeNode treeNode, boolean bDefaultCloseOperation) {
        tree = new JTree(treeNode);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        tree.setCellRenderer(renderer);
        getContentPane().add(new JScrollPane(tree));

        for (int i = 0; i < tree.getRowCount(); i++)
            tree.expandRow(i);

        tree.setUI(new BasicTreeUI() {
                Icon emptyIcon = new Icon() {
                        public void paintIcon(Component c, Graphics g, int x,
                            int y) {
                        }

                        public int getIconWidth() {
                            return 16;
                        }

                        public int getIconHeight() {
                            return 16;
                        }
                    };

                /**
                 * DOCUMENT ME!
                 *
                 * @return DOCUMENT ME!
                 */
                public Icon getExpandedIcon() {
                    return emptyIcon;
                }

                /**
                 * DOCUMENT ME!
                 *
                 * @return DOCUMENT ME!
                 */
                public Icon getCollapsedIcon() {
                    return emptyIcon;
                }
            });

        pack();

        setDefaultCloseOperation(bDefaultCloseOperation
            ? WindowConstants.DO_NOTHING_ON_CLOSE
            : WindowConstants.DISPOSE_ON_CLOSE);
    }

    public void setTreeBackground(Color color) {
        tree.setBackground(color);
        renderer.setBackgroundNonSelectionColor(color);
    }

    /**
     * Returns the tree.
     *
     * @return the tree
     */
    public JTree getTree() {
        return tree;
    }
}
