/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.cm.CmCache;
import net.jxta.impl.cm.FileExpirationService;
import net.jxta.impl.cm.SchedulerService;
import net.jxta.impl.config.Config;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class Cm {
    public static final String RootDirBase = Config.JXTA_HOME + "cm";
    public static final String PublicDirName = "public";
    public static final String PrivateDirName = "private";
    public static final String TmpDirName = "tmp";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$Cm == null ? (class$net$jxta$impl$cm$Cm = Cm.class$("net.jxta.impl.cm.Cm")) : class$net$jxta$impl$cm$Cm).getName());
    private static final Random random = new Random();
    protected static final SchedulerService schedulerService = new SchedulerService();
    protected Hashtable indexes;
    protected Hashtable caches;
    protected File rootDir;
    private FileExpirationService expirer;
    private String INDEXFILENAME;
    private static final int RAW = 0;
    private static final int CACHE = 1;
    private static final int INDEX = 2;
    private int searchMethod;
    private String[] searchType;
    ExpirationListener expireListener;
    static /* synthetic */ Class class$net$jxta$impl$cm$Cm;

    public Cm(String areaName, boolean enableOptimize) {
        this(areaName, new ExpirationListener(){

            public boolean expired(File file) {
                return true;
            }
        }, enableOptimize);
    }

    public Cm(String areaName, ExpirationListener listener, boolean enableOptimize) {
        block21: {
            this.indexes = new Hashtable(4);
            this.caches = new Hashtable(4);
            this.INDEXFILENAME = "cm.idx";
            this.searchMethod = 0;
            this.searchType = new String[]{"RAW", "CACHE", "INDEX"};
            try {
                ResourceBundle cmRsrc = ResourceBundle.getBundle("net.jxta.user");
                String str = cmRsrc.getString("impl.cm.searchMethod").trim();
                if (str.equals("RAW")) {
                    this.searchMethod = 0;
                } else if (str.equals("CACHE")) {
                    this.searchMethod = 1;
                } else if (str.equals("INDEX")) {
                    this.searchMethod = 2;
                }
            }
            catch (MissingResourceException e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block21;
                LOG.warn((Object)"cm search method preference resource not found", (Throwable)e);
            }
        }
        if (!enableOptimize) {
            this.searchMethod = 0;
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Forcing search method to : RAW");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Initializaing with search method : " + this.searchType[this.searchMethod]));
        }
        this.expireListener = listener;
        try {
            File base = new File(RootDirBase);
            File[] docDirs = new File[3];
            FileExpirationService.ExpirationListener expiryNotice = null;
            this.rootDir = new File(base, areaName);
            this.rootDir = new File(this.rootDir.getCanonicalPath());
            switch (this.searchMethod) {
                case 1: 
                case 2: {
                    try {
                        expiryNotice = new FileExpirationService.ExpirationListener(){

                            public boolean expired(File f) {
                                CmCache cmc;
                                boolean needsDelete = Cm.this.expireListener.expired(f);
                                if (!needsDelete) {
                                    return needsDelete;
                                }
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)(" removing " + f + " from cache."));
                                }
                                if (null != (cmc = (CmCache)Cm.this.caches.get(new File(f.getParent()).getName()))) {
                                    cmc.remove(f.getName());
                                }
                                return true;
                            }
                        };
                    }
                    catch (Exception failed) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Initialize of CACHE failed, using RAW");
                        }
                        this.searchMethod = 0;
                        enableOptimize = false;
                    }
                    break;
                }
            }
            if (null == expiryNotice) {
                expiryNotice = new FileExpirationService.ExpirationListener(){

                    public boolean expired(File f) {
                        boolean needsDelete = Cm.this.expireListener.expired(f);
                        return needsDelete;
                    }
                };
            }
            docDirs[0] = this.initDir(TmpDirName);
            docDirs[1] = this.initDir(PrivateDirName);
            docDirs[2] = this.initDir(PublicDirName);
            this.expirer = new FileExpirationService(schedulerService, this.rootDir, expiryNotice);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Unable to create Cm", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String createTmpName(StructuredDocument doc) {
        int hash = 0;
        try {
            StringWriter out = new StringWriter();
            ((StructuredTextDocument)doc).sendToWriter(out);
            hash = out.toString().hashCode();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "cm" + Integer.toString(hash);
    }

    public long getPublicationLifetime(String dn, String fn) {
        File file = this.getFile(dn, fn);
        return this.expirer.getPublicationLifetime(file);
    }

    public long getCacheLifetime(String dn, String fn) {
        File file = this.getFile(dn, fn);
        return this.expirer.getCacheLifetime(file);
    }

    public String[] getFileNames(String dn) {
        if (dn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"null directory name");
            }
            return null;
        }
        File dir = new File(this.rootDir, dn);
        return dir.list();
    }

    public String getOldestFile(String dn) {
        if (dn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"null directory name");
            }
            return null;
        }
        try {
            File dir = new File(this.rootDir, dn);
            File[] list = dir.listFiles();
            if (list == null || list.length == 0) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"no files in folder");
                }
                return null;
            }
            long oldestTime = list[0].lastModified();
            File oldest = list[0];
            File file = null;
            long time = 0L;
            int i = 1;
            while (i < list.length) {
                file = list[i];
                time = file.lastModified();
                if (time < oldestTime) {
                    oldest = list[i];
                    oldestTime = time;
                }
                ++i;
            }
            return oldest.getName();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.debug((Object)"Failure determining oldest file", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isFolder(String dn) {
        if (dn == null) {
            return false;
        }
        File dir = new File(this.rootDir, dn);
        return dir.exists() && dir.isDirectory();
    }

    public FileInputStream getInputStream(String dn, String fn) throws IOException {
        return new FileInputStream(this.getFile(dn, fn));
    }

    private File initDir(String dirName) throws IOException {
        File dir = new File(this.rootDir, dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cm cannot create directory " + dir);
        }
        return dir;
    }

    public void createFolder(String f) throws IOException {
        this.createFolder(f, null);
    }

    public synchronized void createFolder(String f, String[] elements) throws IOException {
        File dir = this.initDir(f);
        switch (this.searchMethod) {
            case 1: 
            case 2: {
                if (elements == null || this.caches.get(f) != null) break;
                CmCache cmc = new CmCache(elements, dir);
                this.caches.put(f, cmc);
                new Thread((Runnable)cmc, f + " CmCache ").start();
                break;
            }
        }
    }

    public String createTmpName(String dn) {
        String tryName;
        File dir = new File(this.rootDir, dn);
        while (new File(dir, tryName = "cm" + Integer.toString(random.nextInt())).exists()) {
        }
        return tryName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        try {
            if (this.searchMethod == 1) {
                ((CmCache)this.caches.get(dn)).remove(fn);
            }
            this.expirer.cancelFileExpiration(file);
            Object var5_4 = null;
            if (!file.exists()) return;
            if (file.delete()) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!file.exists() || file.delete()) throw throwable;
            throw new IOException("Cm cannot remove the file " + file);
        }
        throw new IOException("Cm cannot remove the file " + file);
    }

    public boolean exists(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        return file.exists();
    }

    public StructuredDocument restore(String dn, String fn) throws IOException {
        File file = this.getFile(dn, fn);
        return this.restoreFile(file);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] restoreBytes(String dn, String fn) throws IOException {
        block9: {
            file = this.getFile(dn, fn);
            ip = null;
            buffer = null;
            try {
                ip = new FileInputStream(file);
                size = (int)file.length();
                buffer = new byte[size];
                got = 0;
                while (true) {
                    if (got >= size) {
                        break block9;
                    }
                    res = ip.read(buffer, got, size - got);
                    if (-1 == res) {
                        ip.close();
                        var9_9 = null;
                        var11_10 = null;
                        if (ip == null) return var9_9;
                        break;
                    }
                    got += res;
                }
            }
            catch (Throwable var10_16) {
                var11_12 = null;
                if (ip == null) throw var10_16;
                try {
                    ip.close();
                    throw var10_16;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw var10_16;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 113->121)] { 
lbl35:
            // 1 sources

            ip.close();
            return var9_9;
lbl37:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var9_9;
        }
        var11_11 = null;
        if (ip == null) return buffer;
        try {}
        catch (IOException ignored) {
            return buffer;
        }
        ip.close();
        return buffer;
    }

    public void save(String dn, String fn, StructuredDocument doc) throws IOException {
        this.save(dn, fn, doc, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(String dn, String fn, StructuredDocument doc, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        File file = this.getFile(dn, fn);
        FileOutputStream op = null;
        try {
            try {
                this.expirer.scheduleFileExpiration(file, timeoutInMyCache, timeoutForOthers);
                op = new FileOutputStream(file);
                doc.sendToStream(op);
                op.close();
                op = null;
                if (this.searchMethod == 1) {
                    ((CmCache)this.caches.get(dn)).add(fn, doc);
                }
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) throw e;
                LOG.debug((Object)"Cm cannot write doc", (Throwable)e);
                throw e;
            }
            Object var12_8 = null;
            if (op == null) return;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            if (op == null) throw throwable;
            try {
                op.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        op.close();
        return;
    }

    public void saveBytes(String dn, String fn, InputStream source) throws IOException {
        this.saveBytes(dn, fn, source, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    /*
     * Loose catch block
     */
    public void saveBytes(String dn, String fn, InputStream source, long timeoutInMyCache, long timeoutForOthers) throws IOException {
        block18: {
            IOException e22;
            FileOutputStream op;
            block17: {
                block16: {
                    File file = this.getFile(dn, fn);
                    op = null;
                    this.expirer.scheduleFileExpiration(file, timeoutInMyCache, timeoutForOthers);
                    op = new FileOutputStream(file);
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int res;
                        if ((res = source.read(buffer)) == 0) {
                            continue;
                        }
                        if (res == -1) break;
                        op.write(buffer, 0, res);
                    }
                    op.flush();
                    op.close();
                    op = null;
                    source.close();
                    source = new FileInputStream(file);
                    if (this.searchMethod != 1) break block16;
                    ((CmCache)this.caches.get(dn)).add(fn);
                }
                Object var13_11 = null;
                if (source == null) break block17;
                try {
                    source.close();
                    source = null;
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (op != null) {
                try {
                    op.close();
                    op = null;
                }
                catch (IOException e22) {}
            }
            break block18;
            {
                catch (IOException e3) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Cm cannot write doc", (Throwable)e3);
                    }
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var13_12 = null;
                if (source != null) {
                    try {
                        source.close();
                        source = null;
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (op != null) {
                    try {
                        op.close();
                        op = null;
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean cleanupFolder(String dn) throws IOException {
        boolean deleted = true;
        if (null == dn) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"cleanupFolder : dir cannot be null");
            }
            throw new IllegalArgumentException("dir cannot be null");
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)(" cleaning up " + dn));
        }
        File dir = new File(this.rootDir, dn);
        String[] files = this.getFileNames(dn);
        int i = 0;
        while (files != null && i < files.length) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                deleted &= this.cleanupFolder(file.getPath());
            } else {
                this.expirer.cancelFileExpiration(file);
            }
            if (file.exists()) {
                deleted &= file.delete();
            }
            ++i;
        }
        if (!deleted && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)("failed removing : " + dir.getCanonicalPath()));
        }
        return deleted;
    }

    public Enumeration search(String dn, String tag, String value) {
        CmCache cmc;
        if (null == tag || tag.length() == 0) {
            throw new IllegalArgumentException("tag must be non-null and non-empty");
        }
        if (null == value || value.length() == 0) {
            throw new IllegalArgumentException("value must be non-null and non-empty");
        }
        Vector<String> res = new Vector<String>();
        if (this.searchMethod == 1 && (cmc = (CmCache)this.caches.get(dn)).containsKey(tag)) {
            return cmc.query(tag, value);
        }
        String[] files = this.getFileNames(dn);
        if (files == null) {
            return res.elements();
        }
        int i = 0;
        while (i < files.length) {
            if (this.searchFile(dn, files[i], tag, value)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found a hit " + files[i]));
                }
                res.addElement(files[i]);
            }
            ++i;
        }
        return res.elements();
    }

    File getFile(String dn, String fn) {
        File d = new File(this.rootDir, dn);
        if (!d.exists()) {
            d.mkdirs();
        }
        return new File(d, fn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StructuredDocument restoreFile(File file) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("restore document from " + file));
        }
        FileInputStream ip = null;
        StructuredDocument doc = null;
        try {
            ip = new FileInputStream(file);
            doc = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), ip);
            Object var5_4 = null;
            if (ip == null) return doc;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ip == null) throw throwable;
            try {
                ((InputStream)ip).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)ip).close();
            return doc;
        }
        catch (IOException e) {}
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean searchFile(String dn, String fn, String tag, String value) {
        if (null == tag) throw new IllegalArgumentException("tag must be non-null and non-empty");
        if (tag.length() == 0) {
            throw new IllegalArgumentException("tag must be non-null and non-empty");
        }
        if (null == value) throw new IllegalArgumentException("value must be non-null and non-empty");
        if (value.length() == 0) {
            throw new IllegalArgumentException("value must be non-null and non-empty");
        }
        value = value.toUpperCase();
        boolean startswith = false;
        boolean endswith = false;
        boolean matchany = false;
        if ("*".equals(value)) {
            matchany = true;
        } else {
            if (value.charAt(0) == '*') {
                endswith = true;
                value = value.substring(1);
            }
            if (value.charAt(value.length() - 1) == '*') {
                startswith = true;
                value = value.substring(0, value.length() - 1);
            }
            if (value.length() == 0) {
                matchany = true;
            }
        }
        StructuredDocument doc = null;
        try {
            doc = this.restore(dn, fn);
        }
        catch (Exception e) {
            if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
            LOG.debug((Object)("searchFile failed restoring doc: " + e));
            return false;
        }
        if (doc == null) {
            if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
            LOG.debug((Object)"searchFile failed restoring doc: doc is null");
            return false;
        }
        try {
            Object val;
            Enumeration enumeration = doc.getChildren();
            if (!enumeration.hasMoreElements()) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
                LOG.debug((Object)"searchFile failed restoring doc: doc has no elements");
                return false;
            }
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return false;
                }
                Element e = (Element)enumeration.nextElement();
                Object etag = e.getKey();
                if (!(etag instanceof String) || !((String)etag).equalsIgnoreCase(tag)) continue;
                if (matchany) {
                    return true;
                }
                val = e.getValue();
                if (value.getClass().isInstance(val)) break;
            }
            String uVal = ((String)val).toUpperCase();
            if (startswith && !endswith) {
                return uVal.startsWith(value);
            }
            if (endswith && !startswith) {
                return uVal.endsWith(value);
            }
            if (!startswith) return uVal.equals(value);
            if (!endswith) return uVal.equals(value);
            if (uVal.indexOf(value) < 0) return false;
            return true;
        }
        catch (Exception e) {
            if (!LOG.isEnabledFor(Priority.DEBUG)) return false;
            LOG.debug((Object)"searchFile has failed: ", (Throwable)e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        new Thread((Runnable)schedulerService, "SchedulerService").start();
    }

    public static interface ExpirationListener {
        public boolean expired(File var1);
    }
}

