/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.config.ConfigUtil;
import net.jxta.impl.endpoint.Address;

public class HttpConfig {
    private static final int DEFAULT_PORT = 6002;
    private static final String DEFAULT_IMPL = "net.jxta.impl.endpoint.http.HttpTransport";
    private String mImplClassname;
    private EndpointAddress mServerAddress;
    private EndpointAddress mRouterAddress;
    private EndpointAddress mProxyAddress;
    private boolean mUseProxy;
    private boolean mUsePublicAddress;
    private EndpointAddress mPublicAddress;
    private String mPeerID;
    private static final String KEY_SERVER = "Server";
    private static final String KEY_PROXY = "ProxyServer";
    private static final String KEY_USE_PROXY = "UseProxyServer";
    private static final String KEY_ROUTER = "Router";
    private static final String KEY_IMPL = "Impl";

    public static HttpConfig createDefaultConfig() {
        HttpConfig conf = new HttpConfig();
        conf.setImplClassname(DEFAULT_IMPL);
        conf.setServerAddress(new Address("http://localhost:6002"));
        return conf;
    }

    public static HttpConfig newFromXML(TextElement parent) {
        Enumeration enumeration = parent.getChildren();
        if (enumeration == null) {
            return null;
        }
        HttpConfig conf = new HttpConfig();
        while (enumeration.hasMoreElements()) {
            TextElement e = (TextElement)enumeration.nextElement();
            String elname = e.getName();
            if (elname.equals(KEY_IMPL)) {
                conf.mImplClassname = e.getTextValue();
                continue;
            }
            if (elname.equals(KEY_SERVER)) {
                conf.mServerAddress = new Address(e.getTextValue());
                continue;
            }
            if (elname.equals(KEY_ROUTER)) {
                conf.mRouterAddress = new Address(e.getTextValue());
                continue;
            }
            if (elname.equals(KEY_PROXY)) {
                conf.mProxyAddress = new Address(e.getTextValue());
                continue;
            }
            if (elname.equals(KEY_USE_PROXY)) {
                conf.mUseProxy = Boolean.valueOf(e.getTextValue());
                continue;
            }
            if (elname.equals("PublicAddress")) {
                conf.mPublicAddress = new Address(e.getTextValue());
                continue;
            }
            if (!elname.equals("UsePublicAddress")) continue;
            conf.mUsePublicAddress = Boolean.valueOf(e.getTextValue());
        }
        return conf;
    }

    public void writeToXML(StructuredTextDocument doc) {
        TextElement parent = doc.createElement("HTTP");
        doc.appendChild((Element)parent);
        ConfigUtil.writeAddress(doc, parent, this.mServerAddress, KEY_SERVER);
        ConfigUtil.writeAddress(doc, parent, this.mRouterAddress, KEY_ROUTER);
        ConfigUtil.writeAddress(doc, parent, this.mProxyAddress, KEY_PROXY);
        parent.appendChild((Element)doc.createElement(KEY_USE_PROXY, String.valueOf(this.mUseProxy)));
        ConfigUtil.writeAddress(doc, parent, this.mPublicAddress, "PublicAddress");
        parent.appendChild((Element)doc.createElement("UsePublicAddress", String.valueOf(this.mUsePublicAddress)));
        TextElement e = doc.createElement(KEY_IMPL, this.mImplClassname);
        parent.appendChild((Element)e);
    }

    public EndpointAddress getServerAddress() {
        return this.mServerAddress;
    }

    public void setServerAddress(EndpointAddress aAddress) {
        this.mServerAddress = aAddress;
    }

    public String getImplClassname() {
        return this.mImplClassname;
    }

    public void setImplClassname(String aImplClassname) {
        this.mImplClassname = aImplClassname;
    }

    public EndpointAddress getRouterAddress() {
        return this.mRouterAddress;
    }

    public void setRouterAddress(EndpointAddress aRouterAddress) {
        this.mRouterAddress = aRouterAddress;
    }

    public EndpointAddress getProxyAddress() {
        return this.mProxyAddress;
    }

    public void setProxyAddress(EndpointAddress aProxyAddress) {
        this.mProxyAddress = aProxyAddress;
    }

    public boolean getUseProxy() {
        return this.mUseProxy;
    }

    public void setUseProxy(boolean aUseProxy) {
        this.mUseProxy = aUseProxy;
    }

    public EndpointAddress getPublicAddress() {
        return this.mPublicAddress;
    }

    public void setPublicAddress(EndpointAddress aPublicAddress) {
        this.mPublicAddress = aPublicAddress;
    }

    public boolean getUsePublicAddress() {
        return this.mUsePublicAddress;
    }

    public void setUsePublicAddress(boolean aUsePublicAddress) {
        this.mUsePublicAddress = aUsePublicAddress;
    }
}

