/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Vector;
import net.jxta.endpoint.Message;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class EndpointReceiveQueue {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$EndpointReceiveQueue == null ? (class$net$jxta$impl$endpoint$EndpointReceiveQueue = EndpointReceiveQueue.class$("net.jxta.impl.endpoint.EndpointReceiveQueue")) : class$net$jxta$impl$endpoint$EndpointReceiveQueue).getName());
    public static final int Max_Messages = 100;
    private Vector queue = null;
    private boolean closeFlag = false;
    private int maxNbOfMessages = 100;
    private int nbOfQueuedMessages = 0;
    private long nextDroppedWarn = 0L;
    private long nbOfDroppedMessages = 0L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$EndpointReceiveQueue;

    public EndpointReceiveQueue() {
        this(100);
    }

    public EndpointReceiveQueue(int size) {
        this.queue = new Vector(size);
        this.closeFlag = false;
    }

    public synchronized boolean push(Message message) {
        if (this.closeFlag) {
            return false;
        }
        if (this.queue.size() >= this.getMaxNbOfMessages()) {
            ++this.nbOfDroppedMessages;
            long now = System.currentTimeMillis();
            if (now > this.nextDroppedWarn && LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Receive queue full, dropped one message. Now dropped " + this.nbOfDroppedMessages + " messsages."));
                this.nextDroppedWarn = now + 1000L;
            }
            this.queue.removeElementAt(0);
        }
        ++this.nbOfQueuedMessages;
        this.queue.addElement(message);
        this.notify();
        return true;
    }

    public synchronized Message next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        Message result = (Message)this.queue.firstElement();
        this.queue.removeElementAt(0);
        return result;
    }

    public synchronized Message poll(long timeOut) throws InterruptedException {
        if (timeOut < 0L) {
            throw new IllegalArgumentException("timeOut must be >= 0");
        }
        long realTimeOut = System.currentTimeMillis() + timeOut;
        do {
            Message result;
            if (null != (result = this.next())) {
                return result;
            }
            if (this.isClosed()) continue;
            this.wait(timeOut);
            result = this.next();
            if (null != result) {
                return result;
            }
            if (0L != timeOut && (timeOut = realTimeOut - System.currentTimeMillis()) <= 0L) break;
        } while (!this.isClosed());
        return null;
    }

    public Message waitForMessage() throws InterruptedException {
        return this.poll(0L);
    }

    public synchronized boolean isClosed() {
        return this.closeFlag;
    }

    public synchronized void close() {
        this.closeFlag = true;
        this.notifyAll();
    }

    public int getMaxNbOfMessages() {
        return this.maxNbOfMessages;
    }

    public synchronized void setMaxNbOfMessages(int maxMsgs) {
        this.maxNbOfMessages = maxMsgs;
        this.queue.ensureCapacity(maxMsgs);
    }

    public synchronized int getNbOfQueuedMessages() {
        return this.nbOfQueuedMessages;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

