/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.endpoint.Address;
import net.jxta.impl.endpoint.MessageElementEnumerationImpl;
import net.jxta.impl.endpoint.MessageElementImpl;
import net.jxta.util.StringEnumeration;

public class MessageImpl
implements Message {
    private Hashtable namespace2elements = new Hashtable();
    Vector order = new Vector();
    public boolean filtered = false;

    public MessageElement newMessageElement(String name, MimeMediaType type, InputStream in) throws IOException {
        return new MessageElementImpl(name, type, in, -1);
    }

    public MessageElement newMessageElement(String name, MimeMediaType type, InputStream in, int len) throws IOException {
        return new MessageElementImpl(name, type, in, len);
    }

    public MessageElement newMessageElement(String name, MimeMediaType type, byte[] b, int offset, int len) {
        return new MessageElementImpl(name, type, b, offset, len);
    }

    public MessageElement newMessageElement(String nsname, MimeMediaType type, byte[] b) {
        return new MessageElementImpl(nsname, type, b, 0, b.length);
    }

    public boolean removeElement(MessageElement element) {
        String nsname = element.getName();
        if (nsname == null) {
            throw new RuntimeException("Element has null name");
        }
        return this.removeElement(nsname) != null;
    }

    public MessageElement removeElement(String nsname) {
        String[] names = MessageElement.parseName(nsname);
        String namespace = names[0];
        String name = names[1];
        Hashtable elements = (Hashtable)this.namespace2elements.get(namespace);
        if (elements == null) {
            return null;
        }
        MessageElement elfound = (MessageElement)elements.get(name);
        if (elfound == null) {
            return null;
        }
        elements.remove(name);
        this.order.remove(elfound);
        if (elements.size() == 0) {
            this.namespace2elements.remove(namespace);
        }
        return elfound;
    }

    public byte[] getBytes(String nsname) {
        byte[] bytes = null;
        MessageElement el = this.getElement(nsname);
        if (el != null) {
            bytes = el.getBytesOffset();
            int offset = el.getOffset();
            if (offset != 0) {
                byte[] src = bytes;
                bytes = new byte[el.getLength()];
                System.arraycopy(src, el.getOffset(), bytes, 0, el.getLength());
            }
        }
        return bytes;
    }

    public void setBytes(String name, byte[] bytes) {
        this.setBytes(name, bytes, 0, bytes.length);
    }

    public void setBytes(String nsname, byte[] bytes, int offset, int len) {
        MessageElement el = this.getElement(nsname);
        if (el != null) {
            this.removeElement(nsname);
        }
        el = this.newMessageElement(nsname, null, bytes, offset, len);
        this.addElement(el);
    }

    public Enumeration getNamespaces() {
        return this.namespace2elements.keys();
    }

    public boolean hasElement(String nsname) {
        return this.getElement(nsname) != null;
    }

    public MessageElement getElement(String nsname) {
        String[] names = MessageElement.parseName(nsname);
        String namespace = names[0];
        String name = names[1];
        Hashtable elements = (Hashtable)this.namespace2elements.get(namespace);
        if (elements == null) {
            return null;
        }
        return (MessageElement)elements.get(name);
    }

    public long getRawSize() {
        MessageElement el = (MessageElement)this.order.firstElement();
        byte[] bytes = el.getBytesOffset();
        return bytes.length;
    }

    public void addElement(MessageElement element) {
        String[] names = MessageElement.parseName(element.getName());
        String namespace = names[0];
        String name = names[1];
        MessageElement el = this.getElement(element.getName());
        if (el != null) {
            int i = this.order.indexOf(el);
            this.order.setElementAt(element, i);
        } else {
            this.order.addElement(element);
        }
        Hashtable<String, MessageElement> namespaceElements = (Hashtable<String, MessageElement>)this.namespace2elements.get(namespace);
        if (namespaceElements == null) {
            namespaceElements = new Hashtable<String, MessageElement>();
            this.namespace2elements.put(namespace, namespaceElements);
        }
        namespaceElements.put(name, element);
    }

    public MessageElementEnumeration getElements() {
        return this.getElementsInLifoOrder();
    }

    public MessageElementEnumeration getElementsInFifoOrder() {
        return new MessageElementEnumerationImpl(this.order.elements());
    }

    public MessageElementEnumeration getElementsInLifoOrder() {
        Vector v = new Vector();
        Enumeration e = this.order.elements();
        while (e.hasMoreElements()) {
            v.add(0, e.nextElement());
        }
        return new MessageElementEnumerationImpl(v.elements());
    }

    public StringEnumeration getNames() {
        return new StringEnumeration(new Enumeration(){
            private Enumeration elements;
            {
                this.elements = MessageImpl.this.getElementsInLifoOrder();
            }

            public boolean hasMoreElements() {
                return this.elements.hasMoreElements();
            }

            public Object nextElement() {
                MessageElement element = (MessageElement)this.elements.nextElement();
                return element.getName();
            }
        });
    }

    public MessageElementEnumeration getElements(final String namespace) {
        return new MessageElementEnumerationImpl(new Enumeration(){
            private Hashtable elementsTable;
            private Enumeration elements;
            {
                this.elementsTable = (Hashtable)MessageImpl.this.namespace2elements.get(namespace);
                this.elements = this.elementsTable == null ? null : this.elementsTable.elements();
            }

            public boolean hasMoreElements() {
                return this.elements != null && this.elements.hasMoreElements();
            }

            public Object nextElement() {
                if (this.elements == null || !this.elements.hasMoreElements()) {
                    return null;
                }
                return this.elements.nextElement();
            }
        });
    }

    public Object clone() {
        MessageImpl m = new MessageImpl();
        MessageElementEnumeration e = this.getElements();
        while (e.hasMoreElements()) {
            MessageElement el = (MessageElement)e.nextElement();
            m.addElement(el);
        }
        return m;
    }

    public boolean equals(Object o) {
        Message m2 = (Message)o;
        MessageElementEnumeration e1 = this.getElements();
        MessageElementEnumeration e2 = m2.getElements();
        while (e1.hasMoreElements()) {
            MessageElement el2;
            if (!e2.hasMoreElements()) {
                return false;
            }
            MessageElement el1 = e1.nextMessageElement();
            if (el1.equals(el2 = e2.nextMessageElement())) continue;
            return false;
        }
        return !e2.hasMoreElements();
    }

    public EndpointAddress getSourceAddress() {
        Address srcAddr = null;
        byte[] bytes = this.getBytes("jxta:EndpointSourceAddress");
        if (bytes != null) {
            srcAddr = new Address(bytes);
        }
        return srcAddr;
    }

    public EndpointAddress getDestinationAddress() {
        Address dstAddr = null;
        byte[] bytes = this.getBytes("jxta:EndpointDestinationAddress");
        if (bytes != null) {
            dstAddr = new Address(bytes);
        }
        return dstAddr;
    }

    public void setSourceAddress(EndpointAddress srcAddress) {
        this.setBytes("jxta:EndpointSourceAddress", srcAddress.toString().getBytes());
    }

    public void setDestinationAddress(EndpointAddress dstAddress) {
        this.setBytes("jxta:EndpointDestinationAddress", dstAddress.toString().getBytes());
    }

    public void setString(String elementName, String s) {
        this.setBytes(elementName, s.getBytes());
    }

    public String getString(String elementName) {
        byte[] bytes = this.getBytes(elementName);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }
}

