/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.beep;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.beep.BeepSession;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.beepcore.beep.core.BEEPError;
import org.beepcore.beep.core.ByteDataStream;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.lib.Reply;

public class BeepNonBlockingMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger = BeepNonBlockingMessenger.class$("net.jxta.impl.endpoint.beep.BeepNonBlockingMessenger")) : class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger).getName());
    private BeepSession session;
    private Channel channel;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$beep$BeepNonBlockingMessenger;

    public BeepNonBlockingMessenger(BeepSession session) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Constructor");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   dest addr = " + session.getDestEndpoint()));
        }
        this.session = session;
        this.channel = session.getNewChannel();
    }

    public void sendMessage(Message message) throws IOException {
        if (!this.session.isActive()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Session was closed with " + this.session.getDestEndpoint()));
            }
            throw new IOException("Session was closed with " + this.session.getDestEndpoint());
        }
        try {
            message.setDestinationAddress(this.session.getDestEndpoint());
            message.setSourceAddress(this.session.getSrcEndpoint());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessage");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   from = " + this.session.getSrcEndpoint()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("     to = " + this.session.getDestEndpoint()));
            }
            ByteArrayOutputStream messy = new ByteArrayOutputStream();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(messy, message);
            Reply reply = new Reply();
            ByteDataStream msg = new ByteDataStream(messy.toByteArray());
            this.channel.sendMSG((DataStream)msg, (ReplyListener)reply);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"message sent, waiting for reply.");
            }
            DataStream ds = reply.getNextReply().getDataStream();
            InputStream is = ds.getInputStream();
            ByteArrayOutputStream rpy = new ByteArrayOutputStream();
            while (!ds.isComplete() || is.available() > 0) {
                int res = is.read();
                if (-1 == res) continue;
                rpy.write((byte)res);
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"message sent, got reply.");
            }
            if (!rpy.toString().equals("OK") && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Bad reply");
            }
        }
        catch (BEEPError e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Error sending request (" + e.getCode() + ": " + e.getMessage() + ")"));
            }
            return;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Error sending request (" + e.getMessage() + ")"));
            }
            return;
        }
        this.session.updateLastUsed();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"message sent OK");
        }
    }

    public void close() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("close for " + this.session.getDestEndpoint()));
        }
        this.session.releaseChannel(this.channel);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

