/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpMessage {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpMessage == null ? (class$net$jxta$impl$endpoint$http$HttpMessage = HttpMessage.class$("net.jxta.impl.endpoint.http.HttpMessage")) : class$net$jxta$impl$endpoint$http$HttpMessage).getName());
    private String dn;
    private String fn;
    private String doc;
    public static final String CodeTag = "Code";
    public static final String ContentTag = "Msg";
    public static final int Ok = 1;
    public static final int Failed = 2;
    public static final int Empty = 3;
    public static final int Content = 4;
    public static final HttpMessage OKMESSAGE = new HttpMessage(1);
    public static final HttpMessage FAILEDMESSAGE = new HttpMessage(2);
    public static final HttpMessage EMPTYMESSAGE = new HttpMessage(3);
    private static final long MessageLifeTime = 300000L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpMessage;

    public HttpMessage(int code) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.doc = "<Code>" + Integer.toString(code) + "</" + CodeTag + ">";
    }

    public HttpMessage(String buffer) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.doc = buffer;
    }

    public HttpMessage(int code, String buffer) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        String docstart = "<Code>" + Integer.toString(code) + "</" + CodeTag + ">" + "<" + ContentTag + ">\n";
        String docend = "</Msg>";
        this.doc = docstart + buffer + docend;
    }

    public HttpMessage(byte[] buffer) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.doc = new String(buffer);
    }

    public HttpMessage(String dn, String fn) {
        this.dn = null;
        this.fn = null;
        this.doc = null;
        this.dn = dn;
        this.fn = fn;
    }

    public HttpMessage(String dn, String fn, int code, Vector buffers) {
        this(dn, fn, code, HttpMessage.combineBuffers(buffers));
    }

    public HttpMessage(String dn, String fn, Vector buffers) {
        this(dn, fn, HttpMessage.combineBuffers(buffers));
    }

    private static InputStream combineBuffers(Vector buffers) {
        Vector<ByteArrayInputStream> streamParts = new Vector<ByteArrayInputStream>(buffers.size());
        int each = 0;
        while (each < buffers.size()) {
            streamParts.addElement(new ByteArrayInputStream((byte[])buffers.elementAt(each)));
            ++each;
        }
        SequenceInputStream combined = new SequenceInputStream(streamParts.elements());
        return combined;
    }

    public HttpMessage(String dn, String fn, byte[] buffer) {
        this(dn, fn, 4, new ByteArrayInputStream(buffer));
    }

    public HttpMessage(String dn, String fn, InputStream is) {
        this(dn, fn, 4, is);
    }

    public HttpMessage(String dn, String fn, int code, InputStream is) {
        block2: {
            this(dn, fn);
            String docstart = "<Code>" + Integer.toString(code) + "</" + CodeTag + ">" + "<" + ContentTag + ">\n";
            String docend = "</Msg>";
            Vector<InputStream> streamParts = new Vector<InputStream>();
            streamParts.addElement(new ByteArrayInputStream(docstart.getBytes()));
            streamParts.addElement(is);
            streamParts.addElement(new ByteArrayInputStream(docend.getBytes()));
            SequenceInputStream combined = new SequenceInputStream(streamParts.elements());
            try {
                HttpTransport.cm.saveBytes(dn, fn, combined, 300000L, 300000L);
            }
            catch (Exception ignored) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block2;
                LOG.debug((Object)"failed to seve to cm", (Throwable)ignored);
            }
        }
    }

    public byte[] getBytes() {
        if (this.doc == null) {
            try {
                this.doc = new String(HttpTransport.cm.restoreBytes(this.dn, this.fn));
            }
            catch (Exception punt) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"failed to restore from cm", (Throwable)punt);
                }
                return null;
            }
        }
        return this.doc.getBytes();
    }

    public byte[] getData() {
        if (this.doc == null) {
            try {
                this.doc = new String(HttpTransport.cm.restoreBytes(this.dn, this.fn));
            }
            catch (Exception punt) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"failed to restore from cm", (Throwable)punt);
                }
                return null;
            }
        }
        int indexFirst = this.doc.indexOf("<Msg>");
        int indexLast = this.doc.lastIndexOf("</Msg>");
        if (indexFirst == -1 || indexLast == -1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("invalid message " + indexFirst + " " + indexLast));
            }
            return null;
        }
        return this.doc.substring(indexFirst + ContentTag.length() + 3, indexLast).getBytes();
    }

    public int getCode() {
        if (this.doc == null) {
            try {
                this.doc = new String(HttpTransport.cm.restoreBytes(this.dn, this.fn));
            }
            catch (Exception punt) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"failed to restore from cm", (Throwable)punt);
                }
                return -1;
            }
        }
        int indexFirst = this.doc.indexOf("<Code>");
        int indexLast = this.doc.indexOf("</Code>");
        if (indexFirst == -1 || indexLast == -1) {
            return -1;
        }
        String theCode = this.doc.substring(indexFirst + CodeTag.length() + 2, indexLast).trim();
        try {
            return Integer.parseInt(theCode);
        }
        catch (NumberFormatException notCode) {
            return -1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

