/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.http.HttpClient;
import net.jxta.impl.endpoint.http.HttpMessage;
import net.jxta.impl.endpoint.http.HttpNonBlockingMessenger;
import net.jxta.impl.endpoint.http.HttpServer;
import net.jxta.impl.endpoint.http.HttpServerMessenger;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpTransport
implements EndpointProtocol,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpTransport == null ? (class$net$jxta$impl$endpoint$http$HttpTransport = HttpTransport.class$("net.jxta.impl.endpoint.http.HttpTransport")) : class$net$jxta$impl$endpoint$http$HttpTransport).getName());
    static final boolean useBlockingSend = true;
    static final String Register = "reg";
    static final String Receive = "rec";
    static final String BlockingReceive = "blk";
    static final String Send = "snd";
    static final String Ping = "ack";
    static final Cm cm = new Cm("HttpTransport", false);
    static final HttpMessage PingOk = new HttpMessage("Jxta Ping OK");
    static final int LingerDelay = 30000;
    static final int SocketTimeout = 30000;
    static final String MagicWord = "JxtaHttpClient";
    static final int PollingSend = 1;
    static final int BlockingSend = 2;
    private PeerGroup group = null;
    private EndpointService endpoint = null;
    private ThreadGroup myThreadGroup = null;
    private String interfaceAddress = null;
    private InetAddress usingInterface = null;
    private String serverName = null;
    private int serverSocketPort = -1;
    HttpServer server = null;
    String localClientId = null;
    private Vector routers = null;
    private String proxyName = null;
    private URL proxyHost = null;
    private HttpClient pollingThread = null;
    private Hashtable servers = new Hashtable();
    private EndpointAddress publicAddress = null;
    private EndpointAddress publicServerAddress = null;
    private EndpointAddress publicClientAddress = null;
    String HttpSpool;
    String protocolName = "http";
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpTransport;

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeEndpointProtocol(this);
        this.stopPolling();
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        try {
            block46: {
                Enumeration httpChilds;
                Enumeration list;
                this.group = g;
                this.endpoint = g.getEndpointService();
                ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
                PeerAdvertisement configAdv = (PeerAdvertisement)g.getConfigAdvertisement();
                Element param = implAdv.getParam();
                if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                    TextElement pname = (TextElement)list.nextElement();
                    this.protocolName = pname.getTextValue();
                }
                if ((httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                    param = (Element)httpChilds.nextElement();
                } else {
                    httpChilds = param.getChildren(HTTPAdv.getAdvertisementType());
                    if (httpChilds.hasMoreElements()) {
                        param = (Element)httpChilds.nextElement();
                    }
                }
                HTTPAdv adv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
                this.interfaceAddress = adv.getInterfaceAddress();
                if (adv.getRouterEnabled()) {
                    this.routers = adv.getRouters();
                }
                if (adv.getProxyEnabled()) {
                    this.proxyName = adv.getProxy();
                }
                if (adv.getServerEnabled()) {
                    this.serverName = adv.getServer();
                    try {
                        this.serverSocketPort = Integer.parseInt(adv.getPort());
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.ERROR)) break block46;
                        LOG.error((Object)"Bad ServerPort from advertisement");
                    }
                }
            }
            if (this.routers == null) {
                if (this.proxyName != null && LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"This system does not use an external router; ignoring proxy settings.");
                }
                this.proxyName = null;
            } else {
                if (this.serverName != null && LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"This system needs an external router. It cannot be a routing server.");
                }
                this.serverName = null;
            }
            if (this.interfaceAddress == null) {
                this.interfaceAddress = InetAddress.getLocalHost().getHostAddress();
            }
            this.usingInterface = InetAddress.getByName(this.interfaceAddress);
            this.endpoint = g.getEndpointService();
            this.localClientId = g.getPeerID().getUniqueValue().toString();
            if (this.serverName != null) {
                this.publicAddress = this.publicServerAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + this.serverName);
            } else {
                this.publicAddress = this.publicClientAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + MagicWord + this.localClientId);
                if (null != this.proxyName) {
                    try {
                        String host = this.proxyName;
                        int port = 8080;
                        int sepAt = this.proxyName.lastIndexOf(58);
                        if (-1 != sepAt) {
                            host = this.proxyName.substring(0, sepAt);
                            port = Integer.parseInt(this.proxyName.substring(sepAt + 1));
                        }
                        this.proxyHost = new URL("http", host, port, "/");
                    }
                    catch (MalformedURLException badurl) {
                        if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"proxy name was not valid");
                        }
                        this.proxyHost = null;
                    }
                }
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Configuring HTTP Transport");
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Public address : " + this.publicAddress));
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Using interface : " + this.usingInterface.getHostAddress()));
            }
            if (null != this.serverName) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"HTTP in server mode. ");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("HTTP server name: " + (this.serverName == null ? "(none)" : this.serverName)));
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Server port:" + (this.serverSocketPort < 0 ? "(none)" : Integer.toString(this.serverSocketPort))));
                }
            } else {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"HTTP in client mode. (blocking)");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("HTTP routers: " + (this.routers == null ? "(none)" : this.routers.toString())));
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("HTTP proxy: " + (this.proxyHost == null ? "(none)" : this.proxyHost.toString())));
                }
            }
            this.myThreadGroup = new ThreadGroup("HttpTransport " + this.usingInterface.getHostAddress());
            this.HttpSpool = "httpspool_" + this.usingInterface.getHostAddress() + (this.serverSocketPort < 0 ? "" : "_" + Integer.toString(this.serverSocketPort));
            if (!this.initDir(this.HttpSpool)) {
                return;
            }
            this.cleanupAllClients();
            if (this.serverName != null) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Starting server : " + this.serverName));
                }
                this.server = new HttpServer(this.myThreadGroup, this, this.usingInterface, this.serverSocketPort);
                this.server.start();
            } else if (this.routers != null) {
                Enumeration e = this.routers.elements();
                while (e.hasMoreElements()) {
                    String routerName = (String)e.nextElement();
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("Starting client connection with " + routerName));
                    }
                    this.registerWithRemote(routerName);
                    ServerConnection th = new ServerConnection(this.myThreadGroup, this, routerName, this.localClientId);
                    th.start();
                }
            } else if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"There are no HTTP routers defined, no communication will occurr until some are defined.");
            }
            this.endpoint.addEndpointProtocol(this);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Not initialized: " + e.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Initialization exception", (Throwable)e);
            }
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"FIXME: there may be threads that need killing.");
            }
            throw new PeerGroupException(e.getMessage());
        }
    }

    public int getPort() {
        return this.serverSocketPort;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowRouting() {
        return true;
    }

    public synchronized String getProxy() {
        return this.proxyName;
    }

    public synchronized Vector getRouters() {
        return this.routers;
    }

    public synchronized String getServer() {
        return this.serverName;
    }

    public synchronized boolean doesPropagate() {
        return false;
    }

    private String getHttpHeader(String entity) {
        int firstCRLFCRLF = entity.indexOf("\r\n\r\n") + 4;
        int firstLFLF = entity.indexOf("\n\n") + 2;
        int endOfHeader = Math.min(firstCRLFCRLF = firstCRLFCRLF < 4 ? Integer.MAX_VALUE : firstCRLFCRLF, firstLFLF = firstLFLF < 2 ? Integer.MAX_VALUE : firstLFLF);
        if (Integer.MAX_VALUE != endOfHeader) {
            return entity.substring(0, endOfHeader);
        }
        return null;
    }

    public void runReceive(Socket inputSocket) {
        String htmlstart = "<HTML>\n";
        String htmlend = "\n</HTML>\n";
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = inputSocket.getInputStream();
            if (null == inputStream) {
                HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Could not get input stream from socket");
                }
                return;
            }
            HttpMessage outgoingMessage = null;
            String packet = this.getResult(inputStream, false);
            if (packet == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"null message - discard");
                }
                HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
                return;
            }
            String httpHeader = this.getHttpHeader(packet);
            int index = httpHeader.indexOf(" ");
            String cmd = httpHeader.substring(0, index);
            String uri = httpHeader.substring(index + 1, httpHeader.indexOf(" HTTP"));
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Incoming client request : " + cmd + " " + uri));
            }
            if (cmd.equals("GET")) {
                int ii = 0;
                String type = null;
                index = uri.indexOf("/reg/");
                if (index >= 0) {
                    type = Register;
                    ii = index;
                }
                if ((index = uri.indexOf("/rec/")) >= 0) {
                    type = Receive;
                    ii = index;
                }
                if ((index = uri.indexOf("/blk/")) >= 0) {
                    type = BlockingReceive;
                    ii = index;
                }
                if ((index = uri.indexOf("/snd/")) >= 0) {
                    type = Send;
                    ii = index;
                }
                if ((index = uri.indexOf("/ack/")) >= 0) {
                    type = Ping;
                    ii = index;
                }
                if (type == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Unrecognized command in request");
                    }
                    HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
                    return;
                }
                String param = uri.substring(ii + 5);
                if (param.indexOf("/") >= 0) {
                    param = param.substring(0, param.length() - 1);
                }
                if (type.equals(Register)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Registering remote peer");
                    }
                    outgoingMessage = this.register(param);
                }
                if (type.equals(Receive)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Remote peer polls messages");
                    }
                    outgoingMessage = this.processOutgoing(param, false, inputSocket, inputStream);
                }
                if (type.equals(BlockingReceive)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Remote peer polls messages - blocking");
                    }
                    outgoingMessage = this.processOutgoing(param, true, inputSocket, inputStream);
                }
                if (type.equals(Ping)) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Processing ping");
                    }
                    outgoingMessage = this.processPing();
                }
            }
            if (cmd.equals("PUT") || cmd.equals("POST")) {
                int indexFirst = packet.indexOf("<HTML>\n", httpHeader.length());
                int indexLast = packet.lastIndexOf("\n</HTML>\n");
                if (indexFirst < 0 || indexLast <= 0) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Invalid message len=" + packet.length() + " indexFirst=" + indexFirst + " indexLast=" + indexLast));
                    }
                    HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
                    return;
                }
                packet = packet.substring(indexFirst + "<HTML>\n".length(), indexLast);
                outgoingMessage = this.processIncoming(packet);
            }
            if (outgoingMessage != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Sending response for : " + cmd + " " + uri));
                }
                if (null == (outputStream = inputSocket.getOutputStream())) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"HTTP: outputstream is null, message discarded");
                    }
                    HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
                    return;
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Still need response for " + inputSocket.getInetAddress().getHostAddress() + ":" + inputSocket.getPort()));
                }
                return;
            }
            byte[] body = outgoingMessage.getBytes();
            Vector<byte[]> buffers = new Vector<byte[]>();
            buffers.addElement(body);
            HttpTransport.sendResponse(outputStream, buffers, body.length);
            HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("runReceive : Aborting connection to  " + inputSocket.getInetAddress().getHostAddress() + ":" + inputSocket.getPort()), (Throwable)e);
            }
            HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
        }
    }

    public boolean sendHttpPUT(URL url, Enumeration buffers, long size) throws IOException {
        Socket socket = null;
        InputStream ip = null;
        OutputStream op = null;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Client PUT  to " + url));
        }
        if (null == (socket = this.openSocket(url))) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"failed to open socket. Message not sent.");
            }
            return false;
        }
        String hostName = url.getHost();
        int port = url.getPort();
        port = -1 == port ? 80 : port;
        String header = "POST " + url + " HTTP/1.1\r\n" + "Host: " + hostName + ":" + port + "\r\n" + "Content-Type: " + "application/octet-stream\r\n" + "Content-Length: " + (size + 16L) + "\r\n" + "User-Agent: Jxta1.0\r\n\r\n";
        try {
            block9: {
                try {
                    op = socket.getOutputStream();
                    ip = socket.getInputStream();
                    op.write(header.getBytes());
                    op.write("<HTML>\n".getBytes());
                    while (buffers.hasMoreElements()) {
                        byte[] buffer = (byte[])buffers.nextElement();
                        op.write(buffer);
                    }
                    op.write("\n</HTML>\n".getBytes());
                    op.flush();
                    String response = this.getResult(ip, true);
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                    LOG.debug((Object)"Client PUT Message sent");
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"sendHttpPUT failed", (Throwable)e);
                    }
                    boolean bl = false;
                    Object var14_13 = null;
                    HttpTransport.closeSocket(socket, ip, op);
                    return bl;
                }
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            HttpTransport.closeSocket(socket, ip, op);
            throw throwable;
        }
        HttpTransport.closeSocket(socket, ip, op);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendHttpGET(URL url, int type, boolean wantReply) throws IOException {
        String reply;
        OutputStream op;
        InputStream ip;
        Socket socket;
        block18: {
            String string;
            block17: {
                socket = null;
                ip = null;
                op = null;
                reply = null;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Client " + (type == 2 ? "blocking" : "nonblocking") + " GET (" + (wantReply ? "with" : "w/o") + " reply) to " + url));
                }
                try {
                    try {
                        socket = this.openSocket(url);
                        if (null == socket) {
                            if (LOG.isEnabledFor(Priority.WARN)) {
                                LOG.warn((Object)"Client GET failed to open socket. Message not sent.");
                            }
                            string = null;
                            Object var16_11 = null;
                            break block17;
                        }
                        op = socket.getOutputStream();
                        ip = socket.getInputStream();
                        String hostName = url.getHost();
                        int port = url.getPort();
                        port = -1 == port ? 80 : port;
                        String header = "GET " + url + " HTTP/1.1\r\n" + "Host: " + hostName + ":" + port + "\r\n" + "User-Agent: Jxta1.0\r\n" + "Content-Length: 0\r\n\r\n";
                        op.write(header.getBytes());
                        op.flush();
                        if (wantReply) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("Client GET Message sent, " + (type == 2 ? "blocking" : "polling") + " for reply"));
                            } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Client GET Message sent, no reply wanted");
                            }
                        }
                        if (!wantReply) break block18;
                        String response = this.getResult(ip, type == 2);
                        if (response != null) {
                            String httpHeader = this.getHttpHeader(response);
                            int indexFirst = response.indexOf("<HTML>\n", httpHeader.length());
                            int indexLast = response.lastIndexOf("</HTML>");
                            if (indexFirst >= 0 && indexLast > 0) {
                                reply = response.substring(indexFirst + 7, indexLast);
                                break block18;
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"Client GET got invalid reply");
                            }
                            break block18;
                        }
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Client GET wanted reply, but didn't get one");
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("HttpGet to '" + url + "' failed "), (Throwable)e);
                        }
                        Object var16_13 = null;
                        HttpTransport.closeSocket(socket, ip, op);
                        return reply;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    HttpTransport.closeSocket(socket, ip, op);
                    throw throwable;
                }
            }
            HttpTransport.closeSocket(socket, ip, op);
            return string;
        }
        Object var16_12 = null;
        HttpTransport.closeSocket(socket, ip, op);
        return reply;
    }

    private Socket openSocket(URL url) {
        Socket socket;
        block19: {
            int port;
            String hostName;
            block18: {
                socket = null;
                hostName = null;
                port = -1;
                try {
                    String peerName = null;
                    String cmd = null;
                    if (this.proxyHost != null) {
                        hostName = this.proxyHost.getHost();
                        port = this.proxyHost.getPort();
                        cmd = "n/a";
                        peerName = "n/a";
                    } else {
                        hostName = url.getHost();
                        port = url.getPort();
                        port = -1 == port ? 80 : port;
                        String path = url.getFile();
                        int indexStart = path.indexOf(47, 1);
                        cmd = path.substring(1, indexStart);
                        indexStart = path.indexOf("//", indexStart + 1);
                        int indexStop = path.indexOf("/", indexStart + 2);
                        peerName = -1 == indexStart || -1 == indexStop ? "n/a" : path.substring(indexStart + 2, indexStop);
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("openSocket to " + hostName + ":" + port + " (cmd='" + cmd + "' clientId='" + peerName + "')"));
                    }
                }
                catch (Exception urlProcess) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block18;
                    LOG.warn((Object)"openSocket URL processing failed. ", (Throwable)urlProcess);
                }
            }
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException notKnown) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("cannot resolve (DNS) " + hostName));
                }
                return null;
            }
            if (addr == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("host name '" + hostName + "' resolved to localhost"));
                }
                return null;
            }
            try {
                socket = new Socket(addr, port, this.usingInterface, 0);
            }
            catch (ConnectException connectFailure) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Connect to " + addr.getHostAddress() + ":" + port + " on interface " + this.usingInterface.getHostAddress() + " failed : " + connectFailure.toString()));
                }
                return null;
            }
            catch (Exception generalFailure) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Connect to " + addr.getHostAddress() + ":" + port + " on interface " + this.usingInterface.getHostAddress() + " failed : " + generalFailure.toString()));
                }
                return null;
            }
            try {
                socket.setSoLinger(true, 30000);
                socket.setSoTimeout(30000);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block19;
                LOG.debug((Object)"setting socket options failed ", (Throwable)e);
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Connected to " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + " on interface " + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort()));
        }
        return socket;
    }

    private HttpMessage register(String clientId) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Registering client " + clientId));
        }
        if (this.initDir(this.HttpSpool + File.separatorChar + clientId)) {
            this.cleanupClient(clientId);
            return HttpMessage.OKMESSAGE;
        }
        return HttpMessage.FAILEDMESSAGE;
    }

    private synchronized void recordConnection(String server, ServerConnection conn) {
        block2: {
            try {
                this.servers.put(server, conn);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block2;
                LOG.warn((Object)"recordConnection failed", (Throwable)e);
            }
        }
    }

    private synchronized void forgetConnection(String server) {
        block2: {
            try {
                this.servers.remove(server);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block2;
                LOG.warn((Object)"forgetConnection failed", (Throwable)e);
            }
        }
    }

    private synchronized boolean connectedServer(String server) {
        Object conn = null;
        conn = this.servers.get(server);
        return conn != null;
    }

    static boolean sendResponse(OutputStream outputStream, Vector buffers, long len) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendResponse starts");
        }
        if (len < 0L) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"len must be >=0");
            }
            throw new IllegalArgumentException("len must be >=0");
        }
        if (len != 0L && buffers == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"buffers cannot be null for non-zero len response");
            }
            throw new IllegalArgumentException("buffers cannot be null for non-zero len response");
        }
        if (null == outputStream) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"outputstream cannot be null");
            }
            throw new IllegalArgumentException("outputstream cannot be null");
        }
        if (null == buffers) {
            buffers = new Vector<byte[]>(1);
        }
        try {
            int contentLen = (int)len;
            if (len > 0L) {
                contentLen += 16;
                buffers.insertElementAt("<HTML>\n".getBytes(), 0);
                buffers.addElement("\n</HTML>\n".getBytes());
            }
            String reponseHeader = "HTTP/1.0 200 OK\r\nContent-type: application/octet-stream\r\nContent-length: " + Integer.toString(contentLen) + "\r\n" + "\r\n";
            buffers.insertElementAt(reponseHeader.getBytes(), 0);
            int i = 0;
            while (i < buffers.size()) {
                outputStream.write((byte[])buffers.elementAt(i));
                ++i;
            }
            outputStream.flush();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Finished response");
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendResponse exception ", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    static void closeSocket(Socket inputSocket, InputStream inputStream, OutputStream outputStream) {
        block11: {
            block10: {
                block9: {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (Exception e) {
                            if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                            LOG.debug((Object)"closeSocket [1] failed.", (Throwable)e);
                        }
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                        LOG.debug((Object)"closeSocket [2] failed.", (Throwable)e);
                    }
                }
            }
            if (inputSocket != null) {
                try {
                    inputSocket.close();
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                    LOG.debug((Object)"closeSokcet [3] failed.", (Throwable)e);
                }
            }
        }
    }

    private HttpMessage processOutgoing(String clientId, boolean blocking, Socket inputSocket, InputStream inputStream) {
        byte[] buffer;
        HttpServer.ClientConnection client;
        OutputStream outputStream;
        block17: {
            String dn;
            String fn;
            outputStream = null;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processOutgoing for client " + clientId));
            }
            try {
                outputStream = inputSocket.getOutputStream();
            }
            catch (IOException failed) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"couldnt get outputstream for response");
                }
                return null;
            }
            client = null;
            if (!blocking) {
                client = this.server.getClientConnection(clientId);
                if (null != client) {
                    client.close();
                    client = null;
                }
            } else {
                this.server.addClientConnection(clientId, inputSocket, inputStream, outputStream);
            }
            if ((fn = cm.getOldestFile(dn = this.HttpSpool + File.separatorChar + clientId)) == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"No messages for client");
                }
                if (!blocking) {
                    return HttpMessage.EMPTYMESSAGE;
                }
                return null;
            }
            buffer = new HttpMessage(dn, fn).getBytes();
            try {
                cm.remove(dn, fn);
            }
            catch (IOException failed) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block17;
                LOG.warn((Object)("failed to remove cm file : " + dn + File.separatorChar + fn));
            }
        }
        try {
            client = this.server.getClientConnection(clientId);
            if (client != null) {
                Vector<byte[]> buffers = new Vector<byte[]>(1);
                buffers.addElement(buffer);
                client.sendToClient(buffers, buffer.length);
            } else {
                Vector<byte[]> buffers = new Vector<byte[]>();
                buffers.addElement(buffer);
                HttpTransport.sendResponse(outputStream, buffers, buffer.length);
                HttpTransport.closeSocket(inputSocket, inputStream, outputStream);
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"couldnt send reply?");
            }
            return null;
        }
        return null;
    }

    private HttpMessage processIncoming(String data) {
        try {
            byte[] buffer = data.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            Message msg = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).readMessage(bais, msg);
            this.endpoint.demux(msg);
        }
        catch (Exception ignored) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"failure processing incoming", (Throwable)ignored);
            }
            return HttpMessage.FAILEDMESSAGE;
        }
        return HttpMessage.OKMESSAGE;
    }

    public EndpointMessenger getMessenger(EndpointAddress dst) throws IOException {
        String tmp = dst.getProtocolAddress();
        if (tmp.length() > MagicWord.length() && tmp.substring(0, MagicWord.length()).equals(MagicWord)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   getting a server messenger");
            }
            return new HttpServerMessenger(dst, this);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"    getting a client messenger");
        }
        return new HttpNonBlockingMessenger(dst, this);
    }

    public void propagate(Message message, String pName, String pParams, String prunePeer) throws IOException {
    }

    private void startPolling() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"startPolling");
        }
        if (this.pollingThread != null) {
            this.pollingThread.setPolling(true);
            return;
        }
        this.publicAddress = this.publicClientAddress;
        this.pollingThread = new HttpClient(this.myThreadGroup, this);
        this.pollingThread.start();
    }

    private void stopPolling() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"stopPolling");
        }
        if (this.pollingThread == null) {
            return;
        }
        this.pollingThread.endPolling();
        this.pollingThread = null;
        this.publicAddress = this.publicServerAddress;
    }

    boolean pollRemote(URL addr, int type) {
        HttpMessage httpMsg = null;
        byte[] buffer = null;
        String content = null;
        try {
            content = this.sendHttpGET(addr, type, true);
            if (content == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no message to poll (no reponse)");
                }
                return false;
            }
            httpMsg = new HttpMessage(content);
            if (3 == httpMsg.getCode()) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no message to poll(by server code)");
                }
                return false;
            }
            buffer = httpMsg.getData();
            if (buffer == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no message to poll(empty msg body)");
                }
                return false;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            Message msg = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).readMessage(bais, msg);
            this.endpoint.demux(msg);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   polled one message");
            }
            return true;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"pollRemote failed", (Throwable)e);
            }
            return false;
        }
    }

    private boolean registerWithRemote(String authority) {
        block9: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Register with Remote : " + authority));
            }
            try {
                URL addr;
                String result;
                String host = authority;
                int port = 80;
                int sepAt = authority.lastIndexOf(58);
                if (-1 != sepAt) {
                    host = authority.substring(0, sepAt);
                    port = Integer.parseInt(authority.substring(sepAt + 1));
                }
                if ((result = this.sendHttpGET(addr = new URL("http", host, port, "/reg/" + this.localClientId + "/"), 1, true)) != null) {
                    int code = new HttpMessage(result).getCode();
                    if (1 == code) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"register with remote succeeded");
                        }
                        return true;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("register with remote failed with code : " + code));
                    }
                    break block9;
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"register with remote got no response");
                }
                return true;
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                LOG.debug((Object)"register with remote failed for some reason", (Throwable)e);
            }
        }
        return false;
    }

    private String getResult(InputStream ip, boolean blocking) {
        int MAXRETRIES = 8;
        int RETRYINTERVAL = 2000;
        String tmp = "";
        byte[] buffer = null;
        if (!blocking) {
            try {
                int cnt = 0;
                while (true) {
                    int avail = ip.available();
                    if (ip.available() == -1) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"getResult:EOF before we found the message end");
                        }
                        return null;
                    }
                    if (ip.available() == 0) {
                        try {
                            if (++cnt > 8) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)("getResult:Retry count exceeded. Had " + tmp.length() + " bytes"));
                                }
                                return null;
                            }
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)"getResult:Thread interrupted, giving up");
                            }
                            Thread.interrupted();
                            return null;
                        }
                    }
                    buffer = new byte[avail];
                    int got = ip.read(buffer);
                    if (got == 0) continue;
                    cnt = 0;
                    if ((tmp = tmp + new String(buffer, 0, got)).startsWith("GET") || tmp.lastIndexOf("</HTML>") >= 0) break;
                }
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"getResult:caught exception, giving up.", (Throwable)e);
                }
                return null;
            }
        }
        try {
            boolean readSome = false;
            buffer = new byte[4096];
            while (true) {
                int got = 0;
                try {
                    got = ip.read(buffer);
                }
                catch (InterruptedIOException timeout) {
                    got = timeout.bytesTransferred;
                }
                if (got == 0) {
                    if (!readSome) continue;
                    break;
                }
                if (got == -1) break;
                tmp = tmp + new String(buffer, 0, got);
                readSome = true;
            }
            if (0 == tmp.length()) {
                tmp = null;
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getResult: caught exception, giving up.", (Throwable)e);
            }
            return null;
        }
        return tmp;
    }

    public boolean ping(EndpointAddress addr) {
        if (addr == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"ping: address is null");
            }
            return false;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Pinging " + addr));
        }
        if (this.serverName != null) {
            try {
                if (-1 == addr.getProtocolAddress().indexOf(MagicWord)) {
                    return false;
                }
                String dirName = this.HttpSpool + File.separatorChar + addr.getProtocolAddress().substring(MagicWord.length());
                boolean res = cm.isFolder(dirName);
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("ping returns " + res));
                }
                return res;
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"ping [1] failed, returning false", (Throwable)e);
                }
                return false;
            }
        }
        try {
            String tmp = addr.getProtocolAddress();
            if (tmp.startsWith(MagicWord)) {
                return false;
            }
            return this.checkServer(tmp);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"ping [2] failed, returning false", (Throwable)e);
            }
            return false;
        }
    }

    private synchronized boolean checkServer(String server) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("checkServer " + server));
        }
        if (this.connectedServer(server)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  connected server " + server));
            }
            return true;
        }
        if (null != this.pollingThread && this.pollingThread.isPollingHttp(server)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  polling server " + server));
            }
            return true;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  no connection with " + server));
        }
        return false;
    }

    private HttpMessage processPing() {
        return PingOk;
    }

    private boolean initDir(String dn) {
        try {
            cm.createFolder(dn);
            return true;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("cannot create spool folder: " + dn));
            }
            return false;
        }
    }

    private void cleanupAllClients() {
        String[] files;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"cleanupAllClients starts");
        }
        if ((files = cm.getFileNames(this.HttpSpool)) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   no client folders");
            }
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (cm.isFolder(this.HttpSpool + File.separatorChar + files[i])) {
                this.cleanupClient(files[i]);
            }
            ++i;
        }
    }

    private void cleanupClient(String clientId) {
        block3: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("cleanupClient " + clientId));
            }
            try {
                String dirName = this.HttpSpool + File.separatorChar + clientId;
                cm.cleanupFolder(dirName);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("cleanup failed for " + clientId));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ServerConnection
    extends Thread {
        private static final int PollingDelay = 20000;
        private static final int MAXFAILURES = 2;
        private long lastReceivedMsg = 0L;
        private long lastFailure = 0L;
        private int failureMode = 0;
        private URL remoteUrl = null;
        private HttpTransport tp = null;
        private String routerName = null;

        public ServerConnection(ThreadGroup inGroup, HttpTransport tp, String router, String clientId) {
            super(inGroup, null, "Server Connection to " + router);
            this.tp = tp;
            this.routerName = router;
            try {
                String host = router;
                int port = 80;
                int sepAt = router.lastIndexOf(58);
                if (-1 != sepAt) {
                    host = router.substring(0, sepAt);
                    port = Integer.parseInt(router.substring(sepAt + 1));
                }
                this.remoteUrl = new URL("http", host, port, "/blk/" + clientId + "/");
            }
            catch (MalformedURLException badurl) {
                throw new IllegalArgumentException("Invalid server or client id");
            }
        }

        public void run() {
            block10: {
                this.tp.recordConnection(this.routerName, this);
                try {
                    while (true) {
                        if (!this.tp.pollRemote(this.remoteUrl, 2)) {
                            long current = System.currentTimeMillis();
                            if (this.lastFailure == 0L) {
                                this.lastFailure = current;
                                continue;
                            }
                            if (current - this.lastFailure > 20000L) {
                                this.failureMode = 0;
                                this.lastFailure = current;
                                continue;
                            }
                            if (this.failureMode >= 2) {
                                if (LOG.isEnabledFor(Priority.INFO)) {
                                    LOG.info((Object)"HttpTransport reverting to polling mode--too many failures");
                                }
                                break;
                            }
                            ++this.failureMode;
                            try {
                                Thread.sleep(20000L);
                            }
                            catch (InterruptedException woken) {
                                Thread.interrupted();
                            }
                            this.lastFailure = System.currentTimeMillis();
                            continue;
                        }
                        this.failureMode = 0;
                        this.lastReceivedMsg = System.currentTimeMillis();
                    }
                    this.tp.startPolling();
                    this.tp.pollingThread.addPollingHttp(this.routerName);
                    this.tp.forgetConnection(this.routerName);
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor(Priority.FATAL)) break block10;
                    LOG.fatal((Object)("Uncaught Throwable in thread : " + Thread.currentThread().getName()), all);
                }
            }
        }
    }
}

