/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.tcp.Header;
import net.jxta.impl.endpoint.tcp.TcpSocket;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpConnection
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpConnection == null ? (class$net$jxta$impl$endpoint$tcp$TcpConnection = TcpConnection.class$("net.jxta.impl.endpoint.tcp.TcpConnection")) : class$net$jxta$impl$endpoint$tcp$TcpConnection).getName());
    public static final int MaxNbOfMessages = 40;
    private InetAddress inetAddress = null;
    private int port = 0;
    private TcpTransport proto = null;
    private Header header = null;
    private TcpSocket tcpSocket = null;
    private boolean waiting = false;
    private EndpointAddress dstAddress = null;
    private long lastUsed = 0L;
    private String dstAddrString = null;
    private Thread thread = null;
    private EndpointReceiveQueue queue = null;
    private long nbOfMessagesSent = 0L;
    private MimeMediaType appMsg = new MimeMediaType("application/x-jxta-msg");
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpConnection;

    public TcpConnection(EndpointAddress destaddr, TcpTransport p) throws IOException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Constructor\n   addr = " + destaddr.toString()));
        }
        this.header = new Header();
        this.proto = p;
        this.dstAddress = (EndpointAddress)destaddr.clone();
        try {
            String tmp = destaddr.getProtocolAddress();
            int portIndex = tmp.indexOf(":");
            if (portIndex == -1) {
                throw new IOException("Invalid EndpointAddress" + tmp);
            }
            this.port = Integer.valueOf(tmp.substring(portIndex + 1));
            this.inetAddress = InetAddress.getByName(tmp.substring(0, portIndex));
            this.dstAddrString = this.inetAddress.getHostAddress();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Constructor using: " + this.inetAddress.getHostAddress()));
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Bad address " + destaddr.toString()), (Throwable)e);
            }
            throw new IOException("Bad address " + destaddr.toString());
        }
        this.tcpSocket = new TcpSocket(this.inetAddress, this.port);
    }

    private void connect() {
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            if (this.queue == null) {
                this.queue = new EndpointReceiveQueue();
                this.queue.setMaxNbOfMessages(40);
            }
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread((Runnable)this, "TCP Connection to " + this.dstAddrString + " [Unused]");
            this.thread.start();
        }
        Thread.yield();
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.thread != null) {
                try {
                    this.thread.setName("TCP Connection to " + this.dstAddrString + " [" + this.queue.getNbOfQueuedMessages() + ", " + this.nbOfMessagesSent + ", " + (this.isConnected() ? "Connected" : "Disconnected") + " ]");
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)ez1);
                }
            }
        }
    }

    public void sendMessage(Message msg) throws IOException {
        if (this.tcpSocket.getSocket(5000L) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sendMessage() cannot get a socket for " + this.dstAddrString));
            }
            throw new IOException("sendMessage() cannot get a socket for " + this.dstAddrString);
        }
        this.connect();
        TcpConnection tcpConnection = this;
        synchronized (tcpConnection) {
            this.queue.push(msg);
            this.setThreadName();
        }
        Thread.yield();
    }

    public void run() {
        Message msg = null;
        while (true) {
            try {
                msg = this.queue.waitForMessage();
                if (msg == null) {
                    this.thread = null;
                    return;
                }
                this.setThreadName();
                this.doSendMessage(msg);
            }
            catch (InterruptedException ez1) {
                this.thread = null;
                return;
            }
            catch (IOException ez2) {
                this.notifyFailure();
                this.thread = null;
                return;
            }
        }
    }

    private void doSendMessage(Message message) throws IOException {
        if (this.dstAddress == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"sendMessage: no destination address");
            }
            throw new IOException("sendMessage: no destination address");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("sendMessage\n     to = " + this.dstAddress.toString()));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(baos, message);
        baos.close();
        byte[] bytes = baos.toByteArray();
        Vector<byte[]> msgBuffers = new Vector<byte[]>();
        msgBuffers.addElement(new byte[Header.length]);
        msgBuffers.addElement(bytes);
        this.header.cmd = (byte)2;
        this.header.srcAddr = this.proto.usingInterface.getAddress();
        this.header.srcPort = this.proto.serverSocketPort;
        this.header.option = 2;
        this.header.size = bytes.length;
        this.header.buildForNetwork((byte[])msgBuffers.elementAt(0), 0);
        int retryAttempt = 0;
        boolean success = false;
        while (retryAttempt < 2) {
            Socket socket = this.tcpSocket.getSocket(5000L);
            if (socket == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("sendMessage() cannot get a socket for " + this.dstAddress.toString()));
                }
                throw new IOException("sendMessage() cannot get a socket for " + this.dstAddress.toString());
            }
            try {
                OutputStream outputStream = socket.getOutputStream();
                InputStream ip = socket.getInputStream();
                if (retryAttempt == 0) {
                    int rep = 1;
                    int i = ip.available();
                    while (i-- > 0) {
                        rep = ip.read();
                    }
                    if (rep == 0) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Other party wanted the connection closed.");
                        }
                        try {
                            outputStream.close();
                            ip.close();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        this.tcpSocket.close();
                        continue;
                    }
                }
                int eachBuffer = 0;
                while (eachBuffer < msgBuffers.size()) {
                    outputStream.write((byte[])msgBuffers.elementAt(eachBuffer));
                    ++eachBuffer;
                }
                outputStream.flush();
                this.setLastUsed(System.currentTimeMillis());
                success = true;
                break;
            }
            catch (Exception e) {
                ++retryAttempt;
                this.tcpSocket.close();
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)"sendMessage current socket is closed.");
            }
        }
        if (success) {
            ++this.nbOfMessagesSent;
        } else {
            this.tcpSocket.setLastFailed(System.currentTimeMillis());
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"sendMessage failed - exit");
            }
            throw new IOException("sendMessage failed - exit");
        }
        Thread.yield();
    }

    public void notifyActivity() {
        this.tcpSocket.notifyActivity();
    }

    private synchronized void notifyFailure() {
        this.close();
    }

    public synchronized void close() {
        block4: {
            this.tcpSocket.close();
            if (this.queue != null) {
                this.queue.close();
                this.queue = null;
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread = null;
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot interrupt thread for " + this.dstAddrString), (Throwable)ez1);
                }
            }
        }
    }

    public synchronized boolean isConnected() {
        Socket socket = this.tcpSocket.getSocket(1000L);
        return socket != null;
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized void setLastUsed(long time) {
        this.lastUsed = time;
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

