/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpConnectionManager;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpNonBlockingMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpNonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$tcp$TcpNonBlockingMessenger = TcpNonBlockingMessenger.class$("net.jxta.impl.endpoint.tcp.TcpNonBlockingMessenger")) : class$net$jxta$impl$endpoint$tcp$TcpNonBlockingMessenger).getName());
    private static int id = 0;
    private EndpointAddress dstAddress = null;
    private EndpointAddress srcAddress = null;
    private TcpConnectionManager connManager = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpNonBlockingMessenger;

    public TcpNonBlockingMessenger(EndpointAddress destaddr, TcpTransport p, TcpConnectionManager connManager) throws IOException {
        TcpConnection conn;
        this.dstAddress = (EndpointAddress)destaddr.clone();
        this.srcAddress = p.getPublicAddress();
        this.connManager = connManager;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Constructor \n   addr = " + destaddr.toString()));
        }
        if ((conn = connManager.getTcpConnection(destaddr)) == null) {
            throw new IOException("Unable to create connection to " + destaddr.toString());
        }
    }

    public void sendMessage(Message message) throws IOException {
        if (this.dstAddress == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessage: no destination address");
            }
            throw new IOException("sendMessage: null destination address");
        }
        message.setDestinationAddress(this.dstAddress);
        message.setSourceAddress(this.srcAddress);
        TcpConnection conn = this.connManager.getTcpConnection(this.dstAddress);
        if (conn == null) {
            throw new IOException("sendMessage: null destination address");
        }
        conn.sendMessage(message);
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

