/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpSocket
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpSocket == null ? (class$net$jxta$impl$endpoint$tcp$TcpSocket = TcpSocket.class$("net.jxta.impl.endpoint.tcp.TcpSocket")) : class$net$jxta$impl$endpoint$tcp$TcpSocket).getName());
    private static final int TcpConnectionSendBufferSize = 65536;
    private static final int TcpConnectionSoTimeout = 30000;
    private static final int FailureDelay = 600000;
    private InetAddress inetAddress = null;
    private int port = 0;
    private long lastOpened = 0L;
    private long lastFailed = 0L;
    private Socket socket = null;
    private boolean pendingConnection = false;
    private boolean activity = false;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpSocket;

    public TcpSocket(InetAddress inetAddress, int port) {
        this.inetAddress = inetAddress;
        this.port = port;
        this.connect();
    }

    public TcpSocket() {
    }

    public synchronized Socket getSocket(long timeout) {
        if (this.socket != null) {
            return this.socket;
        }
        this.connect();
        if (this.pendingConnection) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                return this.socket;
            }
        }
        return this.socket;
    }

    public synchronized void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized long getLastOpened() {
        return this.lastOpened;
    }

    public synchronized void setLastOpened(long time) {
        this.lastOpened = time;
    }

    public synchronized long getLastFailed() {
        return this.lastFailed;
    }

    public synchronized void setLastFailed(long time) {
        this.lastFailed = time;
    }

    private void connect() {
        boolean doConnect = false;
        TcpSocket tcpSocket = this;
        synchronized (tcpSocket) {
            if (this.pendingConnection) {
                return;
            }
            if (this.lastOpened == 0L || this.lastFailed == 0L || this.activity) {
                if (this.activity) {
                    this.activity = false;
                }
                doConnect = true;
            } else if (this.lastOpened > this.lastFailed) {
                doConnect = true;
            } else if (this.lastFailed + 600000L <= System.currentTimeMillis()) {
                doConnect = true;
            }
            if (!doConnect) {
                return;
            }
            this.pendingConnection = true;
            new Thread((Runnable)this, "TcpSocket open Socket for " + this.inetAddress.getHostAddress()).start();
        }
        Thread.yield();
    }

    public void run() {
        Socket tmp = null;
        try {
            tmp = new Socket(this.inetAddress, this.port);
        }
        catch (IOException ez1) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Cannot open socket for " + this.inetAddress.getHostAddress() + ":" + this.port), (Throwable)ez1);
            }
            TcpSocket tcpSocket = this;
            synchronized (tcpSocket) {
                this.pendingConnection = false;
                this.setLastFailed(System.currentTimeMillis());
                this.socket = null;
                this.notifyAll();
            }
            return;
        }
        try {
            tmp.setSendBufferSize(65536);
            tmp.setTcpNoDelay(true);
            tmp.setSoTimeout(30000);
            tmp.setKeepAlive(true);
        }
        catch (Exception ez1) {
            block17: {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Cannot set socket options", (Throwable)ez1);
                }
                try {
                    tmp.close();
                }
                catch (Exception ez2) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block17;
                    LOG.error((Object)"Cannot close socket.", (Throwable)ez2);
                }
            }
            TcpSocket tcpSocket = this;
            synchronized (tcpSocket) {
                this.setLastFailed(System.currentTimeMillis());
                this.socket = null;
                this.pendingConnection = false;
                this.notifyAll();
            }
            return;
        }
        TcpSocket tcpSocket = this;
        synchronized (tcpSocket) {
            this.socket = tmp;
            this.setLastOpened(System.currentTimeMillis());
            this.pendingConnection = false;
            this.notifyAll();
        }
    }

    public synchronized void close() {
        block7: {
            block6: {
                if (this.pendingConnection) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ez1) {
                        if (!LOG.isEnabledFor(Priority.ERROR)) break block6;
                        LOG.error((Object)"Interrupted. Cannot close socket.", (Throwable)ez1);
                    }
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block7;
                    LOG.error((Object)"Cannot close socket.", (Throwable)ez1);
                }
            }
        }
        this.socket = null;
    }

    public synchronized void notifyActivity() {
        this.activity = true;
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

